/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Id: PNSIF_API.h 46099 2014-06-03 13:37:48Z Artem $
   Last Modification:
    $LastChangedBy: Artem $
    $LastChangedDate: 2014-06-03 15:37:48 +0200 (Di, 03 Jun 2014) $
    $LastChangedRevision: 46099 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    stack interface defines

   Changes:

    Date        Author       Description
    ----------- ------------ ---------------------------------------------------------
    2010-08-19  A. Messer    Added I&M service definitions.

    2010-06-24  D. Janssen   Added a reset to factory settings by packet from the application

    2010-05-04  B. Meyer     fixed mantis #9677 - add information if diagnosis record present
                                to field  ulPnsState  of  PNS_IF_GET_DIAGNOSIS_CNF_T

    2010-04-08  B. Meyer     fixed mantis #9197 - all packets of supported services are now
                                part of union PROFINET_PNS_IF_PACKET_T

    2010-02-10	A. Messer		 Added support for little endian byte order

    2010-02-04	A. Messer		 Adapted to new cmdev api: Use PlugsubmoduleExtended instead of
    												 SetModuleConfiguration Request.

    2009-11-19  A. Messer    Added definition for new startup flag
                                PNS_IF_SYSTEM_CHECK_IND_UNUSED_MODULES_ENABLED and corresponding
                                module and submodule states. (mantis #7590)

    2009-11-05  A. Messer    Added new userv event callback types.

    2009-10-21  B. Meyer     renamed names with input to consume and output to provide
                                to make more clear what is meant

    2009-10-16  B. Meyer     all commands are now inside an enum instead of many single #defines

    2009-10-15  B. Meyer     removed note that CheckInd for all submodules is not supported
                                now the Stack will generate a CheckInd for EVERY submodule requested
                                by the IO-Controller is PNS_IF_SYSTEM_CHECK_IND_ALL_MODULES_ENABLED is set
                                in SetConfigurations ulSystemFlags

    2009-09-04  B. Meyer     extended PNS_IF_CONFIG_STATES_T

    2009-09-03	A. Messer		 Added event callback.

    2009-08-22	A. Messer		 Api change for IOxS support.

    2009-08-20  A. Messer    added PNS_IF_SET_IOXS_CONFIG_REQ.

    2009-07-22	A. Messer		 added PNS_IF_SET_IOIMAGE_REQ.

    2009-04-28  B. Meyer     added prefix PNS_IF_ to defines of Get_Diagnosis-Service

    2009-03-24  B. Meyer     added packet definition for old-style configuration
                             removed some no longer supported packets

    2009-03-18  B. Meyer     added comments about DPMOffsetIOCS to make clear that they are
                                not yet supported

    2009-03-11  B. Meyer     adapted command definition for handling old-style configuration

    2009-03-10  B. Meyer     cleanup and clarification in command code definitions

    2009-01-30  B. Meyer     some adjustments to Set_OEM_Parameters packet to make it easy to
                                extend it in the future

    2009-01-27  B. Meyer     added flag PNS_STATE_CONFIG_LOCKED for usage in PNS_IF_GET_DIAGNOSIS_CNF_T

    2009-01-26  B. Meyer     added some comments to explain usage of ulPnio in several packets
    2009-01-26  B. Meyer     removed useless field bRemanent from the following structs
                                PNS_IF_GET_STATION_NAME_CNF_DATA_T, PNS_IF_GET_STATION_TYPE_CNF_DATA_T,
                                PNS_IF_GET_IP_ADDR_CNF_DATA_T
                             removed useless fields ulPnio, usAddVal1, usAddVal2 from struct
                                PNS_IF_RELEASE_REQ_RSP_DATA_T

    2009-01-23	A. Messer		 Added field ulSeqNum to read/write record responses.
                B. Meyer     fixed some warnings from code-checking tool

    2009-01-21	A. Messer		 Added command and packet structure to restore permanent data
    												 via packet.

    2008-01-13  B. Meyer     added new command and corresponding packet
                                PNS_IF_STORE_REMANENT_DATA_IND, PNS_IF_STORE_REMANENT_DATA_RES

    2008-12-05  B. Meyer     added some new flags to use for  Set_Configuration Request
                             added new command and corresponding packet
                                PNS_IF_SET_OEM_PARAMETERS_REQ

    2008-11-25  B. Meyer     renamed fields (mantis #4883)
                                ulLenInData  -> ulProvDataLen
                                ulLenOutData -> ulConsDataLen
                                in PNS_IF_SUBMODULE_STRUCT_T and PNS_IF_PLUG_SUBMODULE_REQ_DATA_T
                                to make clear what they are used for
                             changed command definition to remove diagnosis to make clear
                                what request to use (mantis #4879)
                                new request command is PNS_IF_REMOVE_DIAG_REQ 0x1FE2

    2008-11-18  B. Meyer     renamed PNS_IF_GET_DEVICE_HANDLE_RES to PNS_IF_GET_DEVICE_HANDLE_CNF

    2008-11-17  A. Messer    added PNS_IF_GET_XMAC_DIAGNOSIS_REQ packet commands and structures

    2008-11-12  B. Meyer     added  PNIO_MODSTATE_E  and  PNIO_SUBSTATE_E  from PNIO_spec.h
                             moved some service-specific definitions from top of this file
                                to the service definition to make it more clear what they are used for

    2008-11-10  B. Meyer     added definition of flag PNS_IF_SYSTEM_ARDY_WOUT_APPL_REG_ENABLED
                                for usage in Set_Configuration_Requests ulSystemFlags
                             fixed some typing errors

    2008-11-07  B. Meyer     added field usReserved to PNS_IF_DEVICE_PARAMETER_T for alignment
                             moved description of SET STACK CONFIGURATION SERVICE from
                                bottom of file to top as it is the most important service

    2008-10-27  B. Meyer     renamed ApplicationReady packet from ind/res to req/cnf to match command-definition

    2008-10-22  B. Meyer     moved some command-definitions around to make clear which to use
                                and which are no longer supported

    2008-10-15  B. Meyer     rearranged the content of this file to make it more user friendly
                             renamed some packets to have the same "look & feel" for all packet definitions

    2008-10-13  B. Meyer     changed value of  PNS_IF_SET_PORT_MAC_REQ  and  PNS_IF_SET_PORT_MAC_CNF
                             changed handling and definition of IOxS in DPM
                                IOPS in DPM is now defined to be directly behind IO-data
                                IOCS DPM-offsets have to be specified by application

    2008-10-09  A. Messer	   added RT-Device packet union

    2008-10-08  A. Messer    added request SET PORT MAC

    2008-10-02	A. Messer	   added packet and bit definitions for GetDiagnosis Request

    2008-09-29  B. Meyer     Warmstart-Confirmation and ModuleConfig-Request
                                no longer contains any data
                                This is changed to meet Hilscher-internal requirements
                                like problems with iniBatch and cifXdriver
                             added parameter usInstanceId to Warmstart Request
                             renamed Indication and Response inside  PNS_IF_MODULE_CFG_PCK_T
                                from  ptInd  to  tInd    and  ptRsp  to tRsp

    2008-09-26  A. Messer    use PNIO_MAX_ORDER_ID instead of PNS_IF_MAX_ORDER_ID_LEN

    2008-09-14  B. Meyer     major update, no longer using 2 different headers
                                but only this one for all services and definitions

    2008-09-13  B. Meyer     many minor changes in naming things
                                SubSlot -> subslot, Off -> Offset
                                Length -> Len, xxLenyy -> xxyyLen
                                SubMod -> Submod, ident -> Id, ID -> Id
                                Mod -> Module, Submodule -> Submod
                                IP-address -> IpAddr, network mask -> NetMask
                                Gateway -> Gateway, align -> reserved
                                ErrCode, ErrDecode etc. -> ulPnio, ReasonCode -> ulPnio
                                RecHndl -> RecordHandle, RecHdnl -> RecordHandle
                                StructId -> UserStructId, SructIdent -> UserStructId
                                StationName -> NameOfStation, StationType -> TypeOfStation
                                added extension us to AddValue1/2
                                type-definition of  hAlarmHandle  changed to TLR_HANDLE
                                type-definition of  hDiagHandle  changed to TLR_HANDLE
                                removed definitions of unused packet PNS_IF_START_STOP_COMM_PCK_T
                             exchanged commands  _RSP  with  _RES  for answers to indications

    2008-09-10  B. Meyer     changed textual definition in struct  PNS_IF_SUBMODULE_STRUCT_T
                                ulLenInData   from IOC -> IOD  to IOD -> IOC
                                ulLenOutData  from IOD -> IOC  to IOC -> IOD
                             added this comment inside  PNS_IF_PLUG_SUBMODULE_REQ_DATA_T
                                to make it clear what is meant
                             added this comment for fIsInputCR in  PNS_IF_CR_INFO_IND_DATA_T
                             added missing typedef to  PNS_IF_HANDLE_DATA_T

    2008-09-01  B. Meyer     added field  fSendApplicationReady  to  PNS_IF_PARAM_END_RSP_DATA_T

    2008-08-25  A. Messer    renamed PNS_IF_FATAL_ERROR_CLB to PNS_FATAL_ERROR_CLB
    2008-08-22  A. Messer    changed PNS_IF_(UN)REGISTER_FATAL_ERROR_CALLBACK_(REQ|CNF) to
                             PNS_(UN)REGISTER_FATAL_ERROR_CALLBACK_(REQ|CNF)
                             changed PNS_IF_REG_FATAL_ERROR_CALLBACK_REQ_DATA_T(tag) to
                             PNS_REG_FATAL_ERROR_CALLBACK_REQ_DATA_T(tag)

    2008-07-21  B. Meyer     fixed some alignment issues in the structures
                                PNS_IF_GET_STATION_NAME_CNF_DATA_T,
                                PNS_IF_GET_STATION_TYPE_CNF_DATA_T,
                                PNS_IF_GET_IP_ADDR_CNF_DATA_T

    2008-07-21  B. Meyer     removed _SET_ from all warmstart-related definitions
                             added comments to warmstart parameters

    2008-07-18  B. Meyer     added field  usSubmodState  to struct  PNS_IF_PLUG_SUBMODULE_REQ_DATA_T
                             added field  usModState  to struct  PNS_IF_PLUG_MODULE_REQ_DATA_T
                             added #defines for this (sub)module states

    2008-07-18  B. Meyer     rework of struct  PNS_IF_SEND_DIAG_ALARM_REQ_DATA_T

    2008-07-15  B. Meyer     added definition  PNS_IF_FATAL_ERROR_CLB  and use it inside
                                PNS_IF_REG_FATAL_ERROR_CALLBACK_REQ_DATA_T
                             changed some comments

    2008-07-14  B. Meyer     removed unnecessary parameters from PNS_IF_ALARM_RSP_DATA_T

    2008-07-09  B. Meyer     added parameter max. number of diag. records to warm start packet

**************************************************************************************/
/**
 * @file PNSIF_API.h
 *  definition of packets exchanged between CMDEV, PNSIF and user application
 *
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 */
#ifndef __PNSIF_API_PUBLIC_H
#define __PNSIF_API_PUBLIC_H

#include "PNIO_spec.h"      /* PROFINET global defines */

/*************************************************************************************/
/* tasks queue name */
#define PNS_IF_QUEUE_NAME            "QUE_PNS_IF"


/*************************************************************************************/
/* global definitions */

#define PNS_IF_MAX_DEVICE_TYPE_LEN       (25)         /**< maximum length of Device_Type */
#define PNS_IF_MAX_LABEL_LEN             (63)         /**< maximum length of label inside NameOfStation */
#define PNS_IF_MIN_LABEL_LEN             (1)          /**< minimum length of label inside NameOfStation */
#define PNS_IF_MAX_N_LABEL_LEN           (3)          /**< maximum amount of labels inside NameOfStation */
#define PNIO_IOCS_LEN                    (1)          /**< length of IOCS in Frames */
#define PNIO_IOPS_LEN                    (1)          /**< length of IOPS in Frames */

#define PNS_IF_MAX_RECORD_DATA_LEN       (1024 * 64)  /**< maximum amount of bytes for acyclic services */
#define PNS_IF_MAX_ALARM_DATA_LEN        (1024)       /**< maximum amount of bytes for alarms */

#define PNS_IF_ALARM_QUEUE_SIZE          (8)          /**< maximum amount alarms to queue */

/*************************************************************************************/
/** @name Task commands
 *
 * command defines */
enum
{
  PNS_IF_PLUG_MODULE_REQ                    = 0x00001F04,
  PNS_IF_PLUG_MODULE_CNF                    = 0x00001F05,
  PNS_IF_PULL_MODULE_REQ                    = 0x00001F06,
  PNS_IF_PULL_MODULE_CNF                    = 0x00001F07,
  PNS_IF_PLUG_SUBMODULE_REQ                 = 0x00001F08,
  PNS_IF_PLUG_SUBMODULE_CNF                 = 0x00001F09,
  PNS_IF_PULL_SUBMODULE_REQ                 = 0x00001F0A,
  PNS_IF_PULL_SUBMODULE_CNF                 = 0x00001F0B,
  PNS_IF_PARAM_END_IND                      = 0x00001F0E,
  PNS_IF_PARAM_END_RES                      = 0x00001F0F,

  PNS_IF_SET_APPL_READY_REQ                 = 0x00001F10,
  PNS_IF_SET_APPL_READY_CNF                 = 0x00001F11,
  PNS_IF_AR_CHECK_IND                       = 0x00001F14,
  PNS_IF_AR_CHECK_RES                       = 0x00001F15,
  PNS_IF_CHECK_IND                          = 0x00001F16,
  PNS_IF_CHECK_RES                          = 0x00001F17,
  PNS_IF_RESET_FACTORY_SETTINGS_IND         = 0x00001F18,
  PNS_IF_RESET_FACTORY_SETTINGS_RES         = 0x00001F19,
  PNS_IF_SAVE_STATION_NAME_IND              = 0x00001F1A,
  PNS_IF_SAVE_STATION_NAME_RES              = 0x00001F1B,
  PNS_IF_SAVE_STATION_TYPE_IND              = 0x00001F1C,
  PNS_IF_SAVE_STATION_TYPE_RES              = 0x00001F1D,
  PNS_IF_START_LED_BLINKING_IND             = 0x00001F1E,
  PNS_IF_START_LED_BLINKING_RES             = 0x00001F1F,

  PNS_IF_STOP_LED_BLINKING_IND              = 0x00001F20,
  PNS_IF_STOP_LED_BLINKING_RES              = 0x00001F21,
  PNS_IF_AR_INDATA_IND                      = 0x00001F28,
  PNS_IF_AR_INDATA_RES                      = 0x00001F29,
  PNS_IF_AR_ABORT_IND                       = 0x00001F2A,
  PNS_IF_AR_ABORT_RES                       = 0x00001F2B,
  PNS_IF_APDU_STATUS_IND                    = 0x00001F2E,
  PNS_IF_APDU_STATUS_RES                    = 0x00001F2F,

  PNS_IF_ALARM_IND                          = 0x00001F30,
  PNS_IF_ALARM_RES                          = 0x00001F31,
  PNS_IF_READ_IM_IND                        = 0x00001F32,
  PNS_IF_READ_IM_RES                        = 0x00001F33,
  PNS_IF_WRITE_IM_IND                       = 0x00001F34,
  PNS_IF_WRITE_IM_RES                       = 0x00001F35,
  PNS_IF_READ_RECORD_IND                    = 0x00001F36,
  PNS_IF_READ_RECORD_RES                    = 0x00001F37,
  PNS_IF_WRITE_RECORD_IND                   = 0x00001F3A,
  PNS_IF_WRITE_RECORD_RES                   = 0x00001F3B,

  PNS_IF_ADD_CHANNEL_DIAG_REQ               = 0x00001F46,
  PNS_IF_ADD_CHANNEL_DIAG_CNF               = 0x00001F47,
  PNS_IF_SEND_DIAG_ALARM_REQ                = 0x00001F4C,
  PNS_IF_SEND_DIAG_ALARM_CNF                = 0x00001F4D,

  PNS_IF_RETURN_OF_SUB_REQ                  = 0x00001F50,
  PNS_IF_RETURN_OF_SUB_CNF                  = 0x00001F51,
  PNS_IF_SEND_PROCESS_ALARM_REQ             = 0x00001F52,
  PNS_IF_SEND_PROCESS_ALARM_CNF             = 0x00001F53,
  PNS_IF_ADD_EXTENDED_DIAG_REQ              = 0x00001F54,
  PNS_IF_ADD_EXTENDED_DIAG_CNF              = 0x00001F55,
  PNS_IF_ADD_GENERIC_DIAG_REQ               = 0x00001F58,
  PNS_IF_ADD_GENERIC_DIAG_CNF               = 0x00001F59,

  PNS_IF_REGISTER_AP_REQ                    = 0x00001F62,
  PNS_IF_REGISTER_AP_CNF                    = 0x00001F63,
/* it is highly recommended NOT to use the SET_WARMSTART-Service to configure */
/* the IO-Device stack -> if possible use PNS_IF_SET_CONFIGURATION_REQ instead */
  PNS_IF_SET_WARMSTART_PARAM_REQ            = 0x00001F6A,
  PNS_IF_SET_WARMSTART_PARAM_CNF            = 0x00001F6B,

  PNS_IF_LINK_STATE_CHANGE_IND              = 0x00001F70,
  PNS_IF_LINK_STATE_CHANGE_RES              = 0x00001F71,

  PNS_IF_UNREGISTER_AP_REQ                  = 0x00001F8A,
  PNS_IF_UNREGISTER_AP_CNF                  = 0x00001F8B,
  PNS_IF_GET_STATION_TYPE_REQ               = 0x00001F8C,
  PNS_IF_GET_STATION_TYPE_CNF               = 0x00001F8D,
  PNS_IF_GET_STATION_NAME_REQ               = 0x00001F8E,
  PNS_IF_GET_STATION_NAME_CNF               = 0x00001F8F,
  PNS_IF_SET_SUBM_STATE_REQ                 = 0x00001F92,
  PNS_IF_SET_SUBM_STATE_CNF                 = 0x00001F93,

  PNS_IF_GET_DEVICE_HANDLE_REQ              = 0x00001FB0,
  PNS_IF_GET_DEVICE_HANDLE_CNF              = 0x00001FB1,
  PNS_IF_GET_DIAGNOSIS_REQ                  = 0x00001FB2,
  PNS_IF_GET_DIAGNOSIS_CNF                  = 0x00001FB3,
  PNS_IF_SAVE_IP_ADDR_IND                   = 0x00001FB8,
  PNS_IF_SAVE_IP_ADDR_RES                   = 0x00001FB9,
  PNS_IF_GET_IP_ADDR_REQ                    = 0x00001FBC,
  PNS_IF_GET_IP_ADDR_CNF                    = 0x00001FBD,

 /* it is highly recommended NOT to use the SET_OLD_CONFIGURATION-Service */
 /* to configure the IO-Device stack -> if possible use PNS_IF_SET_CONFIGURATION_REQ instead */
  PNS_IF_SET_OLD_CONFIGURATION_REQ          = 0x00001FC0,
  PNS_IF_SET_OLD_CONFIGURATION_CNF          = 0x00001FC1,


  PNS_IF_CONNECT_REQ_DONE_IND               = 0x00001FD4,
  PNS_IF_CONNECT_REQ_DONE_RES               = 0x00001FD5,
  PNS_IF_RELEASE_RECV_IND                   = 0x00001FD6,
  PNS_IF_RELEASE_RECV_RES                   = 0x00001FD7,
  PNS_IF_ABORT_CONNECTION_REQ               = 0x00001FD8,
  PNS_IF_ABORT_CONNECTION_CNF               = 0x00001FD9,
  PNS_REGISTER_FATAL_ERROR_CALLBACK_REQ     = 0x00001FDA,
  PNS_REGISTER_FATAL_ERROR_CALLBACK_CNF     = 0x00001FDB,
  PNS_IF_USER_ERROR_IND                     = 0x00001FDC,
  PNS_IF_USER_ERROR_RES                     = 0x00001FDD,
  PNS_UNREGISTER_FATAL_ERROR_CALLBACK_REQ   = 0x00001FDE,
  PNS_UNREGISTER_FATAL_ERROR_CALLBACK_CNF   = 0x00001FDF,

  PNS_IF_SET_PORT_MAC_REQ                   = 0x00001FE0,
  PNS_IF_SET_PORT_MAC_CNF                   = 0x00001FE1,
  PNS_IF_SET_CONFIGURATION_REQ              = 0x00001FE2,
  PNS_IF_SET_CONFIGURATION_CNF              = 0x00001FE3,
  PNS_IF_GET_XMAC_DIAGNOSIS_REQ             = 0x00001FE4,
  PNS_IF_GET_XMAC_DIAGNOSIS_CNF             = 0x00001FE5,
  PNS_IF_REMOVE_DIAG_REQ                    = 0x00001FE6,
  PNS_IF_REMOVE_DIAG_CNF                    = 0x00001FE7,
  PNS_IF_SET_OEM_PARAMETERS_REQ             = 0x00001FE8,
  PNS_IF_SET_OEM_PARAMETERS_CNF             = 0x00001FE9,
  PNS_IF_STORE_REMANENT_DATA_IND            = 0x00001FEA,
  PNS_IF_STORE_REMANENT_DATA_RES            = 0x00001FEB,
  PNS_IF_LOAD_REMANENT_DATA_REQ             = 0x00001FEC,
  PNS_IF_LOAD_REMANENT_DATA_CNF             = 0x00001FED,

  PNS_IF_SET_IOIMAGE_REQ                    = 0x00001FF0,
  PNS_IF_SET_IOIMAGE_CNF                    = 0x00001FF1,
  PNS_IF_SET_IOXS_CONFIG_REQ                = 0x00001FF2,
  PNS_IF_SET_IOXS_CONFIG_CNF                = 0x00001FF3,
  PNS_IF_RESET_FACTORY_SETTINGS_REQ         = 0x00001FF4,
  PNS_IF_RESET_FACTORY_SETTINGS_CNF         = 0x00001FF5,
  PNS_IF_FSU_DATA_ADJUST_IND                = 0x00001FF6,
  PNS_IF_FSU_DATA_ADJUST_CNF                = 0x00001FF7,
  PNS_IF_PARAMET_SPEEDUP_SUPPORTED_IND      = 0x00001FF8,
  PNS_IF_PARAMET_SPEEDUP_SUPPORTED_RSP      = 0x00001FF9
};


/** @} */


/** Values the device handle field can take */
enum
{
  PNS_IF_DEVICE_HANDLE_ALL_DEVICES = 0,
  PNS_IF_DEVICE_HANDLE_DEVICE_1,
  PNS_IF_DEVICE_HANDLE_DEVICE_SAR_DA,
  PNS_IF_DEVICE_HANDLE_DEVICE_MAX,
};


/*************************************************************************************/
/** @name fatal error callback function type definition
 *
 * The following type is used for fatal error callback function.
 * @{
 */
typedef TLR_VOID(*PNS_FATAL_ERROR_CLB)(TLR_UINT32 ulErrorCode, TLR_VOID* pvUserParam);

/** @} */

/*************************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__PNSIF_API_PACKET)
#endif


/*************************************************************************************/
/** @name CRInfo related definitions
 *
 * The following structs are used inside CR_Info_Indication and contains information about FrameOffsets
 * of specific slot/subslot combinations inside the cyclic frame.
 *
 * @{
 */
typedef __PACKED_PRE struct PNS_IF_IOCR_OBJ_Ttag
{
  /** slot */
  TLR_UINT16             usSlot;
  /** subslot */
  TLR_UINT16             usSubslot;
  /** FrameOffset of data represented by this Object */
  TLR_UINT32             ulReserved;
} __PACKED_POST PNS_IF_IOCR_OBJ_T;

typedef PNS_IF_IOCR_OBJ_T     PNS_IF_IOCR_IODATA_OBJ_T;
typedef PNS_IF_IOCR_OBJ_T     PNS_IF_IOCR_IOCS_OBJ_T;

typedef __PACKED_PRE struct PNS_IF_IOCR_API_OBJ_Ttag
{
  /** the API */
  TLR_UINT32            ulApi;
  /** number of IOData Objects inside this API */
  TLR_UINT16            usNumDataObjects;
  /** number of IOCS Objects inside this API */
  TLR_UINT16            usNumIOCSObjects;
} __PACKED_POST PNS_IF_IOCR_API_OBJ_T;

/** @} */


/*************************************************************************************/
/** @name Device parameter definition
 *
 * The following struct contains the device parameters needed by the stack.
 *
 * @{
 */

/*************************************************************************************/
/* Device Parameter Systemflag definitions */

#define PNS_IF_SYSTEM_START_AUTO_START                   0x00000000
#define PNS_IF_SYSTEM_START_APPL_CONTROLLED              0x00000001

#define PNS_IF_SYSTEM_DATA_STA_DISABLED                  0x00000000
#define PNS_IF_SYSTEM_DATA_STA_ENABLED                   0x00000002

#define PNS_IF_SYSTEM_LONG_DATA_STA_DISABLED             0x00000000
#define PNS_IF_SYSTEM_LONG_DATA_STA_ENABLED              0x00000004

/* leave some entries free for possible further extensions of siemens stack based IO-Device */

/* shall the stack answer I&M Requests alone or redirect them to application? */
#define PNS_IF_SYSTEM_STACK_HANDLE_I_M_DISABLED          0x00000000
#define PNS_IF_SYSTEM_STACK_HANDLE_I_M_ENABLED           0x00000100

/* shall the stack send ApplicationReady even if no application is registered? */
/* ATTENTION: use this flag at your own risk */
#define PNS_IF_SYSTEM_ARDY_WOUT_APPL_REG_DISABLED        0x00000000
#define PNS_IF_SYSTEM_ARDY_WOUT_APPL_REG_ENABLED         0x00000200

/* shall the stack use the Hilscher default parameters for handling of I&M0 ? */
/* PNS_IF_SET_OEM_PARAMETERS_REQ has to be used to set the parameter */
#define PNS_IF_SYSTEM_USE_OEM_PARAMETERS_DISABLE         0x00000000
#define PNS_IF_SYSTEM_USE_OEM_PARAMETERS_ENABLE          0x00000400

/* shall the stack send CheckIndications for properly configured modules */
#define PNS_IF_SYSTEM_CHECK_IND_ALL_MODULES_DISABLED     0x00000000
#define PNS_IF_SYSTEM_CHECK_IND_ALL_MODULES_ENABLED      0x00000800

/* shall the stack handle LinkDown during runtime as fatal error ? */
/* Hint: This can be useful to test the applications implementation of */
/* FatalErrorCallback or handling of ErrorIndication packet */
#define PNS_IF_SYSTEM_HANDLE_LINK_DOWN_AS_FATAL_DISABLED 0x00000000
#define PNS_IF_SYSTEM_HANDLE_LINK_DOWN_AS_FATAL_ENABLED  0x00001000

/* shall the stack send CheckIndications for modules not requested by
 * the io-controller */
#define PNS_IF_SYSTEM_CHECK_IND_UNUSED_MODULES_DISABLED  0x00000000
#define PNS_IF_SYSTEM_CHECK_IND_UNUSED_MODULES_ENABLED   0x00002000

/* if set remanent data will not be stored by the stack */
#define PNS_IF_SYSTEM_DISABLE_STORE_REMANENT_DISABLE     0x00000000
#define PNS_IF_SYSTEM_DISABLE_STORE_REMANENT_ENABLED     0x00004000

/* shall the stack swap the byte order of io data. attention: the
 * default byteorder is big endian. If the user requests little
 * endian the stack has to be provided with structure information.
 * (IO_SIGNALS_CONFIGURE_SIGNAL_REQ_T / PNS_IF_SET_CONFIGURATION_REQUEST_REQ_T)
 * Using little endian may have a deep impact on cpu usage!) */
#define PNS_IF_SYSTEM_BYTEORDER_BIG_ENDIAN               0x00000000
#define PNS_IF_SYSTEM_BYTEORDER_LITTLE_ENDIAN            0x00000008

/* if link state state indication's shall be issued.
 * just enabling with PNS_IF_SYSTEM_ENABLE_LINK_STATE_INDICATION is not enough to see
 * the indications, also an application has to be registered */
#define PNS_IF_SYSTEM_ENABLE_LINK_STATE_INDICATION       0x00000000
#define PNS_IF_SYSTEM_DISABLE_LINK_STATE_INDICATION      0x00008000

/* shall the stack check if IO-data offsets in IO-image (or DPM) */
/* provided by application are valid? */
/* ATTENTION: disabling this check may lead to inconsistent IO-data */
/*            in case of faulty application configuration */
/* ATTENTION: disabling this check will lead to invalid stack response */
/*            to service RCX_GET_DPM_IO_INFO_REQ */
#define PNS_IF_SYSTEM_ENABLE_IO_OFFSET_CHECKING           0x00000000
#define PNS_IF_SYSTEM_DISABLE_IO_OFFSET_CHECKING          0x00010000


typedef __PACKED_PRE struct PNS_IF_DEVICE_PARAMETER_Ttag
{
  TLR_UINT32 ulSystemFlags;                               /* flags to use are defined in this file */
  TLR_UINT32 ulWdgTime;                                   /* DPM watchdog time*/
  TLR_UINT32 ulVendorId;                                  /* the Vendor ID */
  TLR_UINT32 ulDeviceId;                                  /* the Device ID */
  TLR_UINT32 ulMaxAr;                                     /* currently unused */
  TLR_UINT32 ulCompleteInputSize;                         /* max. combined amount of Input bytes */
  TLR_UINT32 ulCompleteOutputSize;                        /* max. combined amount of Output bytes */
  TLR_UINT32 ulNameOfStationLen;                          /* length of NameOfStation */
  TLR_UINT8  abNameOfStation[PNIO_MAX_NAME_OF_STATION];   /* the NameOfStation */
  TLR_UINT32 ulTypeOfStationLen;                          /* length of TypeOfStation */
  TLR_UINT8  abTypeOfStation[PNIO_MAX_TYPE_OF_STATION];   /* the TypeOfStation */
  TLR_UINT8  abDeviceType[PNS_IF_MAX_DEVICE_TYPE_LEN +3]; /* the DeviceType - ignore the last 3 padding bytes ! */
  TLR_UINT8  abOrderId[PNIO_MAX_ORDER_ID];                /* the OrderID (pad with spaces (0x20) */

  TLR_UINT32 ulIpAddr;                                    /* IP Address, default: 0.0.0.0 */
  TLR_UINT32 ulNetMask;                                   /* Netmask, default: 0.0.0.0 */
  TLR_UINT32 ulGateway;                                   /* Gateway, default: 0.0.0.0 */
  TLR_UINT16 usHwRevision;                                /* Hardware Revision, default: 0 */
  TLR_UINT16 usSwRevision1;                               /* Software Revision 1, default: 0 */
  TLR_UINT16 usSwRevision2;                               /* Software Revision 2, default: 0 */
  TLR_UINT16 usSwRevision3;                               /* Software Revision 3, default: 0 */
  TLR_UINT8  bSwRevisionPrefix;                           /* Software Prefix, default: 0 */
  TLR_UINT8  bReserved;                                   /* reserved, shall be set to 0 */
  TLR_UINT16 usMaxDiagRecords;                            /* max. amaount of parallel Diagnosis records, default: 256 */
  TLR_UINT16 usInstanceId;                                /* GSDML-parameter ObjectUUID_LocalIndex, default: 1 */
  TLR_UINT16 usReserved;                                  /* reserved, shall be set to 0 */
} __PACKED_POST PNS_IF_DEVICE_PARAMETER_T;

/** @} */

/*************************************************************************************/
/** @name Module Configuration specific definitions
 *
 * The following structs are used inside Set_Configuration request and contain information
 * about the (sub)modules the stack shall use.
 *
 * @{
 */
typedef __PACKED_PRE struct PNS_IF_API_STRUCT_Ttag
{
  /* API */
  TLR_UINT32                        ulApi;
  /* number of Submodule-Items to follow */
  TLR_UINT32                        ulNumSubmodItems;
} __PACKED_POST PNS_IF_API_STRUCT_T;

typedef __PACKED_PRE struct PNS_IF_SUBMODULE_STRUCT_Ttag
{
  /* the slot this submodule belongs to */
  TLR_UINT16                        usSlot;
  /* the subslot of this submodule */
  TLR_UINT16                        usSubslot;
  /* Module ID to which this submodule belongs */
  TLR_UINT32                        ulModuleId;
  /* Submodule ID */
  TLR_UINT32                        ulSubmodId;
  /* length of provider data (sent by IO-Device, received by IO-Controller) */
  TLR_UINT32                        ulProvDataLen;
  /* length of consumer data (sent by IO-Controller, received by IO-Device) */
  TLR_UINT32                        ulConsDataLen;
  /* offset in DPM where consumer data is copied to */
  TLR_UINT32                        ulDPMOffsetIn;
  /* offset in DPM where provider data is taken from */
  TLR_UINT32                        ulDPMOffsetOut;
  /* offset where to put IOPS provider state for this submodule relative to beginning of IOPS block in dpm output area to */
  TLR_UINT16                        usOffsetIOPSProvider;
  /* offset where to take IOPS provider state of this submodule relative to beginning of IOPS block in dpm input area from */
  TLR_UINT16                        usOffsetIOPSConsumer;
  /* reserved for future usage */
  TLR_UINT32                        ulReserved[2];
} __PACKED_POST PNS_IF_SUBMODULE_STRUCT_T;

typedef __PACKED_PRE struct PNS_IF_MODULE_CFG_REQ_DATA_Ttag
{
  /* number of API elements to follow */
  TLR_UINT32                   ulNumApi;

  /** first API (mandatory) **/
  /* API has dynamic structure following following schema

  PNS_IF_API_STRUCT_T          tApi1;
  PNS_IF_SUBMODULE_STRUCT_T    atSubmod[tApi1.ulNumSubmodItems];
  */

  /** second and more APIs (optional) **/
  /*
  ...
  */

  /** last API (optional) **/
  /*
  PNS_IF_API_STRUCT_T          tApiN;
  PNS_IF_SUBMODULE_STRUCT_T    atSubmod[tApiN.ulNumSubmodItems];
  */

} __PACKED_POST PNS_IF_MODULE_CFG_REQ_DATA_T;

typedef __PACKED_PRE struct PNS_IF_SIGNAL_CFG_REQ_DATA_Ttag
{
  /* number of Signal elements to follow */
  TLR_UINT32                   ulNumSignals;

  /* array of ulNumSignals count IO_SIGNALS_CONFIGURE_SIGNAL_REQ_DATA_T
   * structures follows  */
} __PACKED_POST PNS_IF_SIGNAL_CFG_REQ_DATA_T;



/** @} */


/*************************************************************************************/
/** @name Link status specific definitions
 *
 * The following struct is used for handling LinkStatus related changes.
 *
 * @{
 */
typedef __PACKED_PRE struct PNS_IF_LINK_STATUS_DATA_Ttag
{
  TLR_UINT32  ulPort;
  TLR_BOOLEAN fIsFullDuplex;
  TLR_BOOLEAN fIsLinkUp;
  TLR_UINT32  ulSpeed;
} __PACKED_POST PNS_IF_LINK_STATUS_DATA_T;

/** @} */


/*************************************************************************************/
/** @name Packet with DeviceHandle definition
 *
 * The following packet contains of packet header and hDeviceHandle and is used for various services.
 * @{
 */
typedef __PACKED_PRE struct PNS_IF_HANDLE_DATA_Ttag
{
  TLR_UINT32 hDeviceHandle;
} __PACKED_POST PNS_IF_HANDLE_DATA_T;

typedef struct PNS_IF_HANDLE_PACKET_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_HANDLE_DATA_T                      tData;
} PNS_IF_HANDLE_PACKET_T;


/** @} */

/** @name extended status block layout definition
 *
 * The following structure defines the layout of the extended status block
 * @{
 * */
typedef __PACKED_PRE struct NETX_STATUS_STRUCTUREtag
{
  TLR_UINT8   bStatusArea;
  TLR_UINT8   bStatusTypeID;
  TLR_UINT16  usNumOfStatusEntries;
  TLR_UINT32  ulStatusOffset;
} __PACKED_POST NETX_STATUS_STRUCTURE;

typedef __PACKED_PRE struct PNS_IF_EXTENDED_STATUS_BLOCK_Ttag
{
  TLR_UINT8 abUnused[172];

  TLR_UINT8 abReserved[3];

  TLR_UINT8 bNumOfStateStruct;

  NETX_STATUS_STRUCTURE atStatusStruct[24];

} __PACKED_POST PNS_IF_EXTENDED_STATUS_BLOCK_T;

typedef enum PNS_IF_STATUS_TYPE_Etag
{
  PNS_IF_STATUS_TYPE_UNDEFINED    = 0,
  PNS_IF_STATUS_TYPE_IOPS_BITLIST,
  PNS_IF_STATUS_TYPE_IOPS_BYTELIST,
} PNS_IF_STATUS_TYPE_E;
/** @} */


/*************************************************************************************/
/** @name Packet Definition
 *
 * The following defined structures represent the packets of the several services,
 * which are supported by the task.
 * @{
 */

/*
 * SET STACK CONFIGURATION SERVICE
 */

/* Note:
 * If the request packet defined below is transfered through DPM
 * the case may occur that the packet in total will be bigger than
 * the amount of data the rcX-DPM mailbox can handle at once.
 * For this scenario a mechanism to transfer the packet in a sequence
 * of several smaller packets is defined in Hilscher DualPortMemory Manual.
 * This sequenced way is supported by the firmware.
 *
 * The second and all later sequenced packet shall consist of the
 * TLR_PACKET_HEADER_T directly followed by the content of bytes.
 * The fields ulTotalConfigPckLen, tWarmstart and tModule shall NOT be present.
 */

/* Request packet */
typedef __PACKED_PRE struct PNS_IF_SET_CONFIGURATION_REQUEST_DATA_Ttag
{
  /** total length of this configuration request */
  /* this length is needed to handle the case that the request is transfered */
  /* in more than 1 sequence through DPM */
  /* it shall contain the total length (in summ) of all sequenced packets (without packet headers) */
  TLR_UINT32                                ulTotalConfigPckLen;
  /** the device parameters */
  PNS_IF_DEVICE_PARAMETER_T                 tDeviceParameters;
  /** the module configuration */
  /* please have a look at the definition of this struct - it is highly dynamic */
  PNS_IF_MODULE_CFG_REQ_DATA_T              tModuleConfig;
} __PACKED_POST PNS_IF_SET_CONFIGURATION_REQUEST_DATA_T;

typedef struct PNS_IF_SET_CONFIGURATION_REQUEST_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_SET_CONFIGURATION_REQUEST_DATA_T   tData;
} PNS_IF_SET_CONFIGURATION_REQUEST_REQ_T;

/* Confirmation packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_SET_CONFIGURATION_REQUEST_CNF_T;

/* packet union */
typedef union PNS_IF_SET_CONFIGURATION_REQUEST_PCK_Ttag
{
  PNS_IF_SET_CONFIGURATION_REQUEST_REQ_T    tReq;
  PNS_IF_SET_CONFIGURATION_REQUEST_CNF_T    tCnf;
} PNS_IF_SET_CONFIGURATION_REQUEST_PCK_T;

/** @} */


/*
 * GET DEVICE HANDLE SERVICE
 */

/* Request packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_GET_DEVICE_HANDLE_REQ_T;

/* Confirmation packet */
typedef PNS_IF_HANDLE_PACKET_T              PNS_IF_GET_DEVICE_HANDLE_CNF_T;

/* packet union */
typedef union PNS_IF_GET_DEVICE_HANDLE_PCK_Ttag
{
  PNS_IF_GET_DEVICE_HANDLE_REQ_T            tReq;
  PNS_IF_GET_DEVICE_HANDLE_CNF_T            tCnf;
} PNS_IF_GET_DEVICE_HANDLE_PCK_T;


/*
 * REGISTER APPLICATION SERVICE
 */

/* Request packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_REGISTER_APPLICATION_REQ_T;

/* Confirmation packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_REGISTER_APPLICATION_CNF_T;

/* packet union */
typedef union PNS_IF_REGISTER_APPLICATION_PCK_Ttag
{
  PNS_IF_REGISTER_APPLICATION_REQ_T         tReq;
  PNS_IF_REGISTER_APPLICATION_CNF_T         tCnf;
} PNS_IF_REGISTER_APPLICATION_PCK_T;


/*
 * UNREGISTER APPLICATION SERVICE
 */

/* Request packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_UNREGISTER_APPLICATION_REQ_T;

/* Confirmation packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_UNREGISTER_APPLICATION_CNF_T;

/* packet union */
typedef union PNS_IF_UNREGISTER_APPLICATION_PCK_Ttag
{
  PNS_IF_UNREGISTER_APPLICATION_REQ_T       tReq;
  PNS_IF_UNREGISTER_APPLICATION_CNF_T       tCnf;
} PNS_IF_UNREGISTER_APPLICATION_PCK_T;


/*
 * PLUG MODULE SERVICE
 */

enum
{
  PNS_IF_PLUG_CORRECT_MODULE = 0,         /**< the correct module is plugged */
  PNS_IF_PLUG_SUBSTITUTE_MODULE,          /**< a substitute module is plugged */
};

/* Request packet */
typedef __PACKED_PRE struct PNS_IF_PLUG_MODULE_REQ_DATA_Ttag
{
  TLR_UINT32 hDeviceHandle;
  TLR_UINT32 ulApi;
  TLR_UINT32 ulSlot;
  TLR_UINT32 ulModuleId;
  TLR_UINT16 usModuleState; /* module state: 0 = correct module, 1 = substitute module */
} __PACKED_POST PNS_IF_PLUG_MODULE_REQ_DATA_T;

typedef struct PNS_IF_PLUG_MODULE_REQ_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_PLUG_MODULE_REQ_DATA_T             tData;
} PNS_IF_PLUG_MODULE_REQ_T;

/* Confirmation packet */
typedef PNS_IF_PLUG_MODULE_REQ_T            PNS_IF_PLUG_MODULE_CNF_T;

/* union packet */
typedef union PNS_IF_PLUG_MODULE_PCK_Ttag
{
  /** request packet */
  PNS_IF_PLUG_MODULE_REQ_T                  tReq;
  /** confirmation packet */
  PNS_IF_PLUG_MODULE_CNF_T                  tCnf;
} PNS_IF_PLUG_MODULE_PCK_T;


/*
 * PLUG SUBMODULE SERVICE
 */

enum
{
  PNS_IF_PLUG_CORRECT_SUBMODULE = 0,      /**< the correct submodule is plugged */
  PNS_IF_PLUG_SUBSTITUTE_SUBMODULE,       /**< a substitute submodule is plugged */
};

/* Extended plug submodule data structure (since stack versions V3.4) */
typedef __PACKED_PRE struct PNS_IF_PLUG_SUBMODULE_EXTENDED_REQ_DATA_Ttag
{
  TLR_UINT32 hDeviceHandle;
  TLR_UINT32 ulApi;
  TLR_UINT32 ulSlot;
  TLR_UINT32 ulSubslot;
  TLR_UINT32 ulSubmodId;
  /* provider data is data sent by IO-Device and received by IO-Controller */
  TLR_UINT32 ulProvDataLen;
  /* consumer data is data sent by IO-Controller and received by IO-Device */
  TLR_UINT32 ulConsDataLen;
  /* offset in DPM where Output data (consumed by IO-Device from IO-Controller) is copied to */
  TLR_UINT32 ulDPMOffsetCons;
  /* offset in DPM where Input data (provided by IO-Device to IO-Controller) is taken from */
  TLR_UINT32 ulDPMOffsetProv;
  /* offset where to put IOPS provider state for this submodule relative to beginning of IOPS block in dpm output area to */
  TLR_UINT16 usOffsetIOPSProvider;
  /* offset where to take IOPS provider state of this submodule relative to beginning of IOPS block in dpm input area from */
  TLR_UINT16 usOffsetIOPSConsumer;
  /* reserved for future usage */
  TLR_UINT32 ulReserved1;
  /* reserved for future use - maybe needed for DPM Area later */
  TLR_UINT32 ulReserved;
  /* submodule state: 0 = correct submodule, 1 = substitute submodule */
  TLR_UINT16 usSubmodState;
  /* Module identifier (new since V3.4 - Submodules can now be plugged without prior plugging the modules)*/
  TLR_UINT32 ulModuleId;
  /* Module state (new since V3.4 - Submodules can now be plugged without prior plugging the modules)*/
  TLR_UINT16 usModuleState;

} __PACKED_POST PNS_IF_PLUG_SUBMODULE_EXTENDED_REQ_DATA_T;

/* Plug submodule data structure. */
typedef __PACKED_PRE struct PNS_IF_PLUG_SUBMODULE_REQ_DATA_Ttag
{
  TLR_UINT32 hDeviceHandle;
  TLR_UINT32 ulApi;
  TLR_UINT32 ulSlot;
  TLR_UINT32 ulSubslot;
  TLR_UINT32 ulSubmodId;
  /* provider data is data sent by IO-Device and received by IO-Controller */
  TLR_UINT32 ulProvDataLen;
  /* consumer data is data sent by IO-Controller and received by IO-Device */
  TLR_UINT32 ulConsDataLen;
  /* offset in DPM where Output data (consumed by IO-Device from IO-Controller) is copied to */
  TLR_UINT32 ulDPMOffsetCons;
  /* offset in DPM where Input data (provided by IO-Device to IO-Controller) is taken from */
  TLR_UINT32 ulDPMOffsetProv;
  /* offset where to put IOPS provider state for this submodule relative to beginning of IOPS block in dpm output area to */
  TLR_UINT16 usOffsetIOPSProvider;
  /* offset where to take IOPS provider state of this submodule relative to beginning of IOPS block in dpm input area from */
  TLR_UINT16 usOffsetIOPSConsumer;
  /* reserved for future usage */
  TLR_UINT32 ulReserved1;
  /* reserved for future use - maybe needed for DPM Area later */
  TLR_UINT32 ulReserved;
  /* submodule state: 0 = correct submodule, 1 = substitute submodule */
  TLR_UINT16 usSubmodState;
} __PACKED_POST PNS_IF_PLUG_SUBMODULE_REQ_DATA_T;



typedef struct PNS_IF_PLUG_SUBMODULE_REQ_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                         tHead;
  /** packet data */
  PNS_IF_PLUG_SUBMODULE_REQ_DATA_T            tData;
} PNS_IF_PLUG_SUBMODULE_REQ_T;

/* Confirmation packet */
typedef PNS_IF_PLUG_SUBMODULE_REQ_T         PNS_IF_PLUG_SUBMODULE_CNF_T;

/* union packet */
typedef union PNS_IF_PLUG_SUBMODULE_PCK_Ttag
{
  /** request packet */
  PNS_IF_PLUG_SUBMODULE_REQ_T               tReq;
  /** confirmation packet */
  PNS_IF_PLUG_SUBMODULE_CNF_T               tCnf;
} PNS_IF_PLUG_SUBMODULE_PCK_T;

typedef struct PNS_IF_PLUG_SUBMODULE_EXTENDED_REQ_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                         tHead;
  /** packet data */
  PNS_IF_PLUG_SUBMODULE_EXTENDED_REQ_DATA_T   tData;
} PNS_IF_PLUG_SUBMODULE_EXTENDED_REQ_T;

/* Confirmation packet */
typedef PNS_IF_PLUG_SUBMODULE_EXTENDED_REQ_T         PNS_IF_PLUG_SUBMODULE_EXTENDED_CNF_T;

/* union packet */
typedef union PNS_IF_PLUG_SUBMODULE_EXTENDED_PCK_Ttag
{
  /** request packet */
  PNS_IF_PLUG_SUBMODULE_EXTENDED_REQ_T        tReq;
  /** confirmation packet */
  PNS_IF_PLUG_SUBMODULE_EXTENDED_CNF_T        tCnf;
} PNS_IF_PLUG_SUBMODULE_EXTENDED_PCK_T;


/*
 * PULL MODULE SERVICE
 */

/* Request packet */
typedef __PACKED_PRE struct PNS_IF_PULL_MODULE_REQ_DATA_Ttag
{
  TLR_UINT32 hDeviceHandle;
  TLR_UINT32 ulApi;
  TLR_UINT32 ulSlot;
} __PACKED_POST PNS_IF_PULL_MODULE_REQ_DATA_T;

typedef struct PNS_IF_PULL_MODULE_REQ_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_PULL_MODULE_REQ_DATA_T             tData;
} PNS_IF_PULL_MODULE_REQ_T;

/* Confirmation packet */
typedef PNS_IF_PULL_MODULE_REQ_T            PNS_IF_PULL_MODULE_CNF_T;

/* packet union */
typedef union PNS_IF_PULL_MODULE_PCK_Ttag
{
  /** request packet */
  PNS_IF_PULL_MODULE_REQ_T                  tReq;
  /** confirmation packet */
  PNS_IF_PULL_MODULE_CNF_T                  tCnf;
} PNS_IF_PULL_MODULE_PCK_T;


/*
 * PULL SUBMODULE SERVICE
 */

/* Request packet */
typedef __PACKED_PRE struct PNS_IF_PULL_SUBMODULE_REQ_DATA_Ttag
{
  TLR_UINT32 hDeviceHandle;
  TLR_UINT32 ulApi;
  TLR_UINT32 ulSlot;
  TLR_UINT32 ulSubslot;
} __PACKED_POST PNS_IF_PULL_SUBMODULE_REQ_DATA_T;

typedef struct PNS_IF_PULL_SUBMODULE_REQ_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_PULL_SUBMODULE_REQ_DATA_T          tData;
} PNS_IF_PULL_SUBMODULE_REQ_T;

/* Confirmation packet */
typedef PNS_IF_PULL_SUBMODULE_REQ_T         PNS_IF_PULL_SUBMODULE_CNF_T;

/* packet union */
typedef union PNS_IF_PULL_SUBMODULE_PCK_Ttag
{
  /** request packet */
  PNS_IF_PULL_SUBMODULE_REQ_T               tReq;
  /** confirmation packet */
  PNS_IF_PULL_SUBMODULE_CNF_T               tCnf;
} PNS_IF_PULL_SUBMODULE_PCK_T;


/*
 * AR CHECK INDICATION SERVICE
 */

/* Indication packet */
typedef __PACKED_PRE struct PNS_IF_AR_CHECK_IND_DATA_Ttag
{
  TLR_UINT32    hDeviceHandle;
  TLR_UINT16    usARType;
  TLR_UINT32    ulARProperties;
  TLR_UINT32    ulRemoteIpAddr;
  TLR_UINT16    usRemoteNameOfStationLen;
  TLR_UINT8     abRemoteNameOfStation[PNIO_MAX_NAME_OF_STATION];
} __PACKED_POST PNS_IF_AR_CHECK_IND_DATA_T;

typedef struct PNS_IF_AR_CHECK_IND_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_AR_CHECK_IND_DATA_T                tData;
} PNS_IF_AR_CHECK_IND_T;

/* Confirmation packet */
typedef PNS_IF_HANDLE_PACKET_T              PNS_IF_AR_CHECK_RSP_T;

/* Response union */
typedef union PNS_IF_AR_CHECK_PCK_Ttag
{
  /** indication packet */
  PNS_IF_AR_CHECK_IND_T                     tInd;
  /** response packet */
  PNS_IF_AR_CHECK_RSP_T                     tRsp;
} PNS_IF_AR_CHECK_PCK_T;


/*
 * CHECK INDICATION SERVICE
 */

/** Module state code */
typedef enum PNIO_MODSTATE_Etag          /* Module state */
{
  PNIO_MODSTATE_NO_MODULE = 0,           /**< no module plugged in slot */
  PNIO_MODSTATE_WRONG_MODULE,            /**< wrong module plugged in slot */
  PNIO_MODSTATE_PROPER_MODULE,           /**< proper module */
  PNIO_MODSTATE_SUBSTITUTE_MODULE,       /**< substitute, the wrong module can fulfill requirements */
  PNIO_MODSTATE_UNUSED_MODULE,       /**< module not expected by controller */
  PNIO_MODSTATE_CORRECT_MODULE = 0xFFFF, /**< correct module was plugged by application */
} PNIO_MODSTATE_E;

/** submodule state code */
typedef enum PNIO_SUBSTATE_Etag              /* Submodule state */
{
  PNIO_SUBSTATE_NO_SUBMODULE = 0,            /**< no submodule */
  PNIO_SUBSTATE_WRONG_SUBMODULE,             /**< Wrong submodule */
  PNIO_SUBSTATE_PROPER_SUBMODULE,            /**< locked by IO controller */
  PNIO_SUBSTATE_RESERVED_1,                  /**< reserved */
  PNIO_SUBSTATE_APPL_READY_PENDING,          /**< application ready pending */
  PNIO_SUBSTATE_RESERVED_2,                  /**< reserved */
  PNIO_SUBSTATE_RESERVED_3,                  /**< reserved */
  PNIO_SUBSTATE_SUBSTITUTE_SUBMODULE,        /**< substitute, the wrong submodule can fulfill requirements */
  PNIO_SUBSTATE_UNUSED_SUBMODULE,        /**< submodule not expected by controller */
  PNIO_SUBSTATE_CORRECT_SUBMODULE = 0xFFFF,  /**< correct submodule was plugged by application*/
} PNIO_SUBSTATE_E;

/** @} */


/* Indication packet */
typedef __PACKED_PRE struct PNS_IF_CHECK_IND_IND_DATA_Ttag
{
  TLR_UINT32 hDeviceHandle;
  TLR_UINT32 ulApi;
  TLR_UINT32 ulSlot;
  TLR_UINT32 ulSubslot;
  TLR_UINT32 ulModuleId;
  TLR_UINT16 usModuleState;
  TLR_UINT32 ulSubmodId;
  TLR_UINT16 usSubmodState;
  TLR_UINT16 usExpInDataLen;
  TLR_UINT16 usExpOutDataLen;
} __PACKED_POST PNS_IF_CHECK_IND_IND_DATA_T;

typedef struct PNS_IF_CHECK_IND_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_CHECK_IND_IND_DATA_T               tData;
} PNS_IF_CHECK_IND_T;

/* Response packet */
typedef __PACKED_PRE struct PNS_IF_CHECK_IND_RSP_DATA_Ttag
{
  TLR_UINT32 hDeviceHandle;
  TLR_UINT32 ulApi;
  TLR_UINT32 ulSlot;
  TLR_UINT32 ulSubslot;
  TLR_UINT32 ulModuleId;
  TLR_UINT16 usModuleState;
  TLR_UINT32 ulSubmodId;
  TLR_UINT16 usSubmodState;
} __PACKED_POST PNS_IF_CHECK_IND_RSP_DATA_T;

typedef struct PNS_IF_CHECK_RSP_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_CHECK_IND_RSP_DATA_T               tData;
} PNS_IF_CHECK_RSP_T;

/* packet union */
typedef union PNS_IF_CHECK_IND_PCK_Ttag
{
  /** indication packet */
  PNS_IF_CHECK_IND_T                        tInd;
  /** response packet */
  PNS_IF_CHECK_RSP_T                        tRsp;
} PNS_IF_CHECK_IND_PCK_T;


/*
 * CONNECT REQUEST DONE SERVICE
 */

/* Indication packet */
typedef PNS_IF_HANDLE_PACKET_T              PNS_IF_CONNECTREQ_DONE_IND_T;

/* Response packet */
typedef PNS_IF_HANDLE_PACKET_T              PNS_IF_CONNECTREQ_DONE_RSP_T;

/* packet union */
typedef union PNS_IF_CONNECTREQ_DONE_PCK_Ttag
{
  /** indication packet */
  PNS_IF_CONNECTREQ_DONE_IND_T              tInd;
  /** response packet */
  PNS_IF_CONNECTREQ_DONE_RSP_T              tRsp;
} PNS_IF_CONNECTREQ_DONE_PCK_T;


/*
 * APPLICATION READY SERVICE
 */

/* request packet */
typedef PNS_IF_HANDLE_PACKET_T              PNS_IF_APPL_READY_REQ_T;

/* Confirmation packet */
typedef PNS_IF_HANDLE_PACKET_T              PNS_IF_APPL_READY_CNF_T;

/* packet union */
typedef union PNS_IF_APPL_READY_PCK_Ttag
{
  /** request packet */
  PNS_IF_APPL_READY_REQ_T                   tInd;
  /** confirmation packet */
  PNS_IF_APPL_READY_CNF_T                   tRsp;
} PNS_IF_APPL_READY_PCK_T;


/*
 * AR INDATA INDICATION SERVICE
 */

/* Indication packet */
typedef PNS_IF_HANDLE_PACKET_T              PNS_IF_AR_IN_DATA_IND_T;

/* Response packet */
typedef PNS_IF_HANDLE_PACKET_T              PNS_IF_AR_IN_DATA_RSP_T;

/* packet union */
typedef union PNS_IF_AR_IN_DATA_PCK_Ttag
{
  /** indication packet */
  PNS_IF_AR_IN_DATA_IND_T                   tInd;
  /** response packet */
  PNS_IF_AR_IN_DATA_RSP_T                   tRsp;
} PNS_IF_AR_IN_DATA_PCK_T;




/*
 * PARAMETER END SERVICE
 */

/* indication packet */
typedef __PACKED_PRE struct PNS_IF_PARAM_END_IND_DATA_Ttag
{
  TLR_UINT32    hDeviceHandle;
  TLR_UINT32    ulApi;      /* valid only if usSlot    != 0 */
  TLR_UINT16    usSlot;     /* valid only if usSubslot != 0 */
  TLR_UINT16    usSubslot;  /* 0: for all (sub)modules, != 0: for this specifi submodule */
} __PACKED_POST PNS_IF_PARAM_END_IND_DATA_T;

typedef struct PNS_IF_PARAM_END_IND_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_PARAM_END_IND_DATA_T               tData;
} PNS_IF_PARAM_END_IND_T;

/* Response packet */
typedef __PACKED_PRE struct PNS_IF_PARAM_END_RSP_DATA_Ttag
{
  TLR_UINT32    hDeviceHandle;
  TLR_BOOLEAN   fSendApplicationReady; /* set to TRUE to send ApplReady automatically */
} __PACKED_POST PNS_IF_PARAM_END_RSP_DATA_T;

typedef struct PNS_IF_PARAM_END_RSP_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_PARAM_END_RSP_DATA_T               tData;
} PNS_IF_PARAM_END_RSP_T;

/* packet union */
typedef union PNS_IF_PARAM_END_PCK_Ttag
{
  /** indication packet */
  PNS_IF_PARAM_END_IND_T                    tInd;
  /** response packet */
  PNS_IF_PARAM_END_RSP_T                    tRsp;
} PNS_IF_PARAM_END_PCK_T;


/*
 * AR ABORT INDICATION SERVICE
 */

/* Request packet */
typedef __PACKED_PRE struct PNS_IF_AR_ABORT_IND_IND_DATA_Ttag
{
  TLR_UINT32    hDeviceHandle;
  /* Profinet error code, consists of ErrCode, ErrDecode, ErrCode1 and ErrCode2 */
  TLR_UINT32    ulPnio;
} __PACKED_POST PNS_IF_AR_ABORT_IND_IND_DATA_T;

typedef struct PNS_IF_AR_ABORT_IND_IND_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_AR_ABORT_IND_IND_DATA_T            tData;
} PNS_IF_AR_ABORT_IND_IND_T;

/* Confirmation packet */
typedef PNS_IF_HANDLE_PACKET_T              PNS_IF_AR_ABORT_IND_RSP_T;

/* packet union */
typedef union PNS_IF_AR_ABORT_IND_PCK_Ttag
{
  /** indication packet */
  PNS_IF_AR_ABORT_IND_IND_T                 tInd;
  /** response packet */
  PNS_IF_AR_ABORT_IND_RSP_T                 tRsp;

} PNS_IF_AR_ABORT_IND_PCK_T;




/*
 * READ RECORD SERVICE
 */

/* Indication packet */
typedef __PACKED_PRE struct PNS_IF_READ_RECORD_IND_DATA_Ttag
{
  TLR_UINT32    hRecordHandle;
  TLR_UINT32    hDeviceHandle;
  TLR_UINT32    ulSequenceNum;
  TLR_UINT32    ulApi;
  TLR_UINT32    ulSlot;
  TLR_UINT32    ulSubslot;
  TLR_UINT32    ulIndex;
  TLR_UINT32    ulLenToRead;
} __PACKED_POST PNS_IF_READ_RECORD_IND_DATA_T;

typedef struct PNS_IF_READ_RECORD_IND_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_READ_RECORD_IND_DATA_T             tData;
} PNS_IF_READ_RECORD_IND_T;

/* Response packet */
typedef __PACKED_PRE struct PNS_IF_READ_RECORD_RSP_DATA_Ttag
{
  TLR_UINT32    hRecordHandle;
  TLR_UINT32    hDeviceHandle;
  TLR_UINT32    ulSequenceNum;
  TLR_UINT32    ulApi;
  TLR_UINT32    ulSlot;
  TLR_UINT32    ulSubslot;
  TLR_UINT32    ulIndex;
  TLR_UINT32    ulReadLen;
  /* Profinet error code, consists of ErrCode, ErrDecode, ErrCode1 and ErrCode2 */
  TLR_UINT32    ulPnio;
  TLR_UINT16    usAddValue1;
  TLR_UINT16    usAddValue2;
  TLR_UINT8     abRecordData[1024]; /* ATTENTION: in case of LOM the length of abRecordData may be up to PNS_IF_MAX_RECORD_DATA_LEN bytes (BUT never more than ulLenToRead)*/
} __PACKED_POST PNS_IF_READ_RECORD_RSP_DATA_T;

typedef struct PNS_IF_READ_RECORD_RSP_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_READ_RECORD_RSP_DATA_T             tData;
} PNS_IF_READ_RECORD_RSP_T;

/* packet union */
typedef union PNS_IF_READ_RECORD_PCK_Ttag
{
  /** indication packet */
  PNS_IF_READ_RECORD_IND_T                  tInd;
  /** response packet */
  PNS_IF_READ_RECORD_RSP_T                  tRsp;
} PNS_IF_READ_RECORD_PCK_T;


/*
 * WRITE RECORD SERVICE
 */

/* Indication packet */
typedef __PACKED_PRE struct PNS_IF_WRITE_RECORD_IND_DATA_Ttag
{
  TLR_UINT32    hRecordHandle;
  TLR_UINT32    hDeviceHandle;
  TLR_UINT32    ulSequenceNum;
  TLR_UINT32    ulApi;
  TLR_UINT32    ulSlot;
  TLR_UINT32    ulSubslot;
  TLR_UINT32    ulIndex;
  TLR_UINT32    ulLenToWrite;
  TLR_UINT8     abRecordData[1024]; /* ATTENTION: in case of LOM the length of abRecordData may be up to PNS_IF_MAX_RECORD_DATA_LEN bytes */
} __PACKED_POST PNS_IF_WRITE_RECORD_IND_DATA_T;

typedef struct PNS_IF_WRITE_RECORD_IND_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_WRITE_RECORD_IND_DATA_T            tData;
} PNS_IF_WRITE_RECORD_IND_T;

/* Response packet */
typedef __PACKED_PRE struct PNS_IF_WRITE_RECORD_RSP_DATA_Ttag
{
  TLR_UINT32    hRecordHandle;
  TLR_UINT32    hDeviceHandle;
  TLR_UINT32    ulSequenceNum;
  TLR_UINT32    ulApi;
  TLR_UINT32    ulSlot;
  TLR_UINT32    ulSubslot;
  TLR_UINT32    ulIndex;
  TLR_UINT32    ulWriteLen;
  /* Profinet error code, consists of ErrCode, ErrDecode, ErrCode1 and ErrCode2 */
  TLR_UINT32    ulPnio;
  TLR_UINT16    usAddValue1;
  TLR_UINT16    usAddValue2;
} __PACKED_POST PNS_IF_WRITE_RECORD_RSP_DATA_T;

typedef struct PNS_IF_WRITE_RECORD_RSP_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_WRITE_RECORD_RSP_DATA_T            tData;
} PNS_IF_WRITE_RECORD_RSP_T;

/* packet union */
typedef union PNS_IF_WRITE_RECORD_PCK_Ttag
{
  /** indication packet */
  PNS_IF_WRITE_RECORD_IND_T                tInd;
  /** response packet */
  PNS_IF_WRITE_RECORD_RSP_T                tRsp;
} PNS_IF_WRITE_RECORD_PCK_T;

/*
 * RELEASE INDICATION SERVICE
 */

/* Indication packet */
typedef __PACKED_PRE struct PNS_IF_RELEASE_REQ_IND_DATA_Ttag
{
  TLR_UINT32    hDeviceHandle;
  TLR_UINT16    usSessionKey;
} __PACKED_POST PNS_IF_RELEASE_REQ_IND_DATA_T;

typedef struct PNS_IF_RELEASE_REQ_IND_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_RELEASE_REQ_IND_DATA_T             tData;
} PNS_IF_RELEASE_REQ_IND_T;

/* Response packet */
typedef __PACKED_PRE struct PNS_IF_RELEASE_REQ_RSP_DATA_Ttag
{
  TLR_UINT32 hDeviceHandle;
} __PACKED_POST PNS_IF_RELEASE_REQ_RSP_DATA_T;

typedef struct PNS_IF_RELEASE_REQ_RSP_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_RELEASE_REQ_RSP_DATA_T             tData;
} PNS_IF_RELEASE_REQ_RSP_T;

/* packet union */
typedef union PNS_IF_RELEASE_REQ_PCK_Ttag
{
  /** indication packet */
  PNS_IF_RELEASE_REQ_IND_T                  tInd;
  /** response packet */
  PNS_IF_RELEASE_REQ_RSP_T                  tRsp;
} PNS_IF_RELEASE_REQ_PCK_T;


/*
 * SEND PROCESS ALARM SERVICE
 */

/* Request packet */
typedef __PACKED_PRE struct PNS_IF_SEND_PROCESS_ALARM_REQ_DATA_Ttag
{
  TLR_UINT32  hDeviceHandle;
  TLR_UINT32  ulApi;
  TLR_UINT32  ulSlot;
  TLR_UINT32  ulSubslot;
  TLR_UINT32  hAlarmHandle;
  TLR_UINT16  usUserStructId;
  TLR_UINT16  usAlarmDataLen;
  TLR_UINT8   abAlarmData[PNS_IF_MAX_ALARM_DATA_LEN];
} __PACKED_POST PNS_IF_SEND_PROCESS_ALARM_REQ_DATA_T;

typedef struct PNS_IF_SEND_PROCESS_ALARM_REQ_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_SEND_PROCESS_ALARM_REQ_DATA_T      tData;
} PNS_IF_SEND_PROCESS_ALARM_REQ_T;

/* Confirmation packet */
typedef __PACKED_PRE struct PNS_IF_SEND_PROCESS_ALARM_CNF_DATA_Ttag
{
  TLR_UINT32    hDeviceHandle;
  TLR_UINT32    hAlarmHandle;
  /* Profinet error code, consists of ErrCode, ErrDecode, ErrCode1 and ErrCode2 */
  TLR_UINT32    ulPnio;
} __PACKED_POST PNS_IF_SEND_PROCESS_ALARM_CNF_DATA_T;

typedef struct PNS_IF_SEND_PROCESS_ALARM_CNF_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_SEND_PROCESS_ALARM_CNF_DATA_T      tData;
} PNS_IF_SEND_PROCESS_ALARM_CNF_T;

/* packet union */
typedef union PNS_IF_SEND_PROCESS_ALARM_PCK_Ttag
{
  /** request packet */
  PNS_IF_SEND_PROCESS_ALARM_REQ_T           tReq;
  /** confirmation packet */
  PNS_IF_SEND_PROCESS_ALARM_CNF_T           tCnf;
} PNS_IF_SEND_PROCESS_ALARM_PCK_T;


/*
 * ADD CHANNEL DIAGNOSIS RECORD SERVICE
 */

/* Request packet */
typedef __PACKED_PRE struct  PNS_IF_ADD_CHANNEL_DIAG_Ttag
{
  TLR_UINT32  ulApi;
  TLR_UINT32  ulSlot;
  TLR_UINT32  ulSubslot;
  TLR_UINT32  hDiagHandle;
  TLR_UINT16  usChannelNum;
  TLR_UINT16  usChannelProp;
  TLR_UINT16  usChannelErrType;
} __PACKED_POST PNS_IF_ADD_CHANNEL_DIAG_T;

typedef struct PNS_IF_ADD_CHANNEL_DIAG_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_ADD_CHANNEL_DIAG_T                 tData;
} PNS_IF_ADD_CHANNEL_DIAG_REQ_T;

/* Confirmation packet */
typedef PNS_IF_ADD_CHANNEL_DIAG_REQ_T       PNS_IF_ADD_CHANNEL_DIAG_CNF_T;

/* packet union */
typedef union PNS_IF_ADD_CHANNEL_DIAG_PCK_Ttag
{
  PNS_IF_ADD_CHANNEL_DIAG_REQ_T             tReq;
  PNS_IF_ADD_CHANNEL_DIAG_CNF_T             tCnf;
} PNS_IF_ADD_CHANNEL_DIAG_PCK_T;


/*
 * ADD EXTENDED DIAGNOSIS RECORD SERVICE
 */

/* Request packet */
typedef __PACKED_PRE struct PNS_IF_ADD_EXTENDED_DIAG_Ttag
{
  TLR_UINT32  ulApi;
  TLR_UINT32  ulSlot;
  TLR_UINT32  ulSubslot;
  TLR_UINT32  hDiagHandle;
  TLR_UINT16  usChannelNum;
  TLR_UINT16  usChannelProp;
  TLR_UINT16  usChannelErrType;
  TLR_UINT16  usReserved;
  TLR_UINT32  ulExtChannelAddValue;
  TLR_UINT16  usExtChannelErrType;
} __PACKED_POST PNS_IF_ADD_EXTENDED_DIAG_T;

typedef struct PNS_IF_ADD_EXTENDED_DIAG_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_ADD_EXTENDED_DIAG_T                tData;
} PNS_IF_ADD_EXTENDED_DIAG_REQ_T;

/* Confirmation packet */
typedef PNS_IF_ADD_EXTENDED_DIAG_REQ_T      PNS_IF_ADD_EXTENDED_DIAG_CNF_T;

/* packet union */
typedef union PNS_IF_ADD_EXTENDED_DIAG_PCK_Ttag
{
  PNS_IF_ADD_EXTENDED_DIAG_REQ_T            tReq;
  PNS_IF_ADD_EXTENDED_DIAG_CNF_T            tCnf;
} PNS_IF_ADD_EXTENDED_DIAG_PCK_T;


/*
 * ADD GENERIC DIAGNOSIS RECORD SERVICE
 */

/* Request packet */
typedef __PACKED_PRE struct PNS_IF_ADD_GENERIC_DIAG_REQ_DATA_Ttag
{
  TLR_UINT32  ulApi;
  TLR_UINT32  ulSlot;
  TLR_UINT32  ulSubslot;
  TLR_UINT32  hDiagHandle;
  TLR_UINT16  usChannelNum;
  TLR_UINT16  usChannelProp;
  TLR_UINT16  usUserStructId;
  TLR_UINT16  usReserved;
  TLR_UINT16  usDiagDataLen;
  TLR_UINT8   abDiagData[PNS_IF_MAX_ALARM_DATA_LEN];
} __PACKED_POST PNS_IF_ADD_GENERIC_DIAG_REQ_DATA_T;

typedef struct
{
  TLR_PACKET_HEADER_T                 tHead;
  PNS_IF_ADD_GENERIC_DIAG_REQ_DATA_T  tData;
} PNS_IF_ADD_GENERIC_DIAG_REQ_T;

/* Confirmation packet */
typedef __PACKED_PRE struct PNS_IF_ADD_GENERIC_DIAG_CNF_DATA_Ttag
{
  TLR_UINT32  ulApi;
  TLR_UINT32  ulSlot;
  TLR_UINT32  ulSubslot;
  TLR_UINT32  hDiagHandle;
  TLR_UINT16  usChannelNum;
  TLR_UINT16  usChannelProp;
  TLR_UINT16  usUserStructId;
} __PACKED_POST PNS_IF_ADD_GENERIC_DIAG_CNF_DATA_T;

typedef struct
{
  TLR_PACKET_HEADER_T                 tHead;
  PNS_IF_ADD_GENERIC_DIAG_CNF_DATA_T  tData;
} PNS_IF_ADD_GENERIC_DIAG_CNF_T;

/* packet union */
typedef union PNS_IF_ADD_GENERIC_DIAG_PCK_Ttag
{
  PNS_IF_ADD_GENERIC_DIAG_REQ_T             tReq;
  PNS_IF_ADD_GENERIC_DIAG_CNF_T             tCnf;
} PNS_IF_ADD_GENERIC_DIAG_PCK_T;


/*
 * REMOVE DIAGNOSIS RECORD
 */

/* Request packet */
typedef __PACKED_PRE struct PNS_IF_REMOVE_DIAG_REQ_DATA_Ttag
{
  TLR_UINT32 hDiagHandle;
} __PACKED_POST PNS_IF_REMOVE_DIAG_REQ_DATA_T;

typedef struct PNS_IF_REMOVE_DIAG_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_REMOVE_DIAG_REQ_DATA_T             tData;
} PNS_IF_REMOVE_DIAG_REQ_T;

/* Confirmation packet */
typedef PNS_IF_REMOVE_DIAG_REQ_T            PNS_IF_REMOVE_DIAG_CNF_T;

/* packet union */
typedef union PNS_IF_REMOVE_DIAG_PCK_Ttag
{
  PNS_IF_REMOVE_DIAG_REQ_T                  tReq;
  PNS_IF_REMOVE_DIAG_CNF_T                  tCnf;
} PNS_IF_REMOVE_DIAG_PCK_T;


/*
 * SEND DIAGNOSIS ALARM SERVICE
 */

/* Request packet */
typedef __PACKED_PRE struct PNS_IF_SEND_DIAG_ALARM_REQ_DATA_Ttag
{
  TLR_UINT32    hDeviceHandle;
  TLR_UINT32    hAlarmHandle;
  TLR_UINT32    hDiagHandle;
} __PACKED_POST PNS_IF_SEND_DIAG_ALARM_REQ_DATA_T;

typedef struct PNS_IF_SEND_DIAG_ALARM_REQ_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_SEND_DIAG_ALARM_REQ_DATA_T         tData;
} PNS_IF_SEND_DIAG_ALARM_REQ_T;

/* Confirmation packet */
typedef __PACKED_PRE struct PNS_IF_SEND_DIAG_ALARM_CNF_DATA_Ttag
{
  TLR_UINT32    hDeviceHandle;
  TLR_UINT32    hAlarmHandle;
  /* Profinet error code, consists of ErrCode, ErrDecode, ErrCode1 and ErrCode2 */
  TLR_UINT32    ulPnio;
} __PACKED_POST PNS_IF_SEND_DIAG_ALARM_CNF_DATA_T;

typedef struct PNS_IF_SEND_DIAG_ALARM_CNF_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_SEND_DIAG_ALARM_CNF_DATA_T         tData;
} PNS_IF_SEND_DIAG_ALARM_CNF_T;

/* packet union */
typedef union PNS_IF_SEND_DIAG_ALARM_PCK_Ttag
{
  /** request packet */
  PNS_IF_SEND_DIAG_ALARM_REQ_T              tReq;
  /** confirmation packet */
  PNS_IF_SEND_DIAG_ALARM_CNF_T              tCnf;
} PNS_IF_SEND_DIAG_ALARM_PCK_T;


/*
 * ALARM INDICATION SERVICE
 */

/* Indication packet */
typedef __PACKED_PRE struct PNS_IF_ALARM_IND_DATA_Ttag
{
  TLR_UINT32  hDeviceHandle;
  TLR_UINT32  ulApi;
  TLR_UINT32  ulSlot;
  TLR_UINT32  ulSubslot;
  TLR_UINT32  ulModuleId;
  TLR_UINT32  ulSubmodId;
  TLR_UINT16  usAlarmPriority;
  TLR_UINT16  usAlarmType;
  TLR_UINT16  usAlarmSequence;
  TLR_BOOLEAN fDiagChannelAvailable;
  TLR_BOOLEAN fDiagGenericAvailable;
  TLR_BOOLEAN fDiagSubmodAvailable;
  TLR_BOOLEAN fReserved;
  TLR_BOOLEAN fArDiagnosisState;
  TLR_UINT16  usUserStructId;
  TLR_UINT16  usAlarmDataLen;
  TLR_UINT8   abAlarmData[PNS_IF_MAX_ALARM_DATA_LEN];
} __PACKED_POST PNS_IF_ALARM_IND_DATA_T;

typedef struct PNS_IF_ALARM_IND_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  PNS_IF_ALARM_IND_DATA_T                   tData;
} PNS_IF_ALARM_IND_T;

/* Response packet */
typedef PNS_IF_HANDLE_PACKET_T              PNS_IF_ALARM_RSP_T;

/* packet union */
typedef union PNS_IF_ALARM_PCK_Ttag
{
  /** indication packet */
  PNS_IF_ALARM_IND_T                        tInd;
  /** response packet */
  PNS_IF_ALARM_RSP_T                        tRsp;
} PNS_IF_ALARM_PCK_T;


/*
 * SAVE STATION NAME SERVICE
 */

/* Indication packet */
typedef __PACKED_PRE struct PNS_IF_SAVE_STATION_NAME_IND_DATA_Ttag
{
  TLR_UINT16 usNameLen;
  TLR_UINT8  bRemanent;
  TLR_UINT8  abNameOfStation[PNIO_MAX_NAME_OF_STATION];
} __PACKED_POST PNS_IF_SAVE_STATION_NAME_IND_DATA_T;

typedef struct PNS_IF_SAVE_STATION_NAME_IND_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_SAVE_STATION_NAME_IND_DATA_T       tData;
} PNS_IF_SAVE_STATION_NAME_IND_T;

/* Response packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_SAVE_STATION_NAME_RSP_T;

/* packet union */
typedef union PNS_IF_SAVE_STATION_NAME_PCK_Ttag
{
  PNS_IF_SAVE_STATION_NAME_IND_T            tInd;
  PNS_IF_SAVE_STATION_NAME_RSP_T            tRsp;
} PNS_IF_SAVE_STATION_NAME_PCK_T;


/*
 * SAVE STATION TYPE SERVICE
 */

/* Indication packet */
typedef __PACKED_PRE struct PNS_IF_SAVE_STATION_TYPE_IND_DATA_Ttag
{
  TLR_UINT16 usTypeLen;
  TLR_UINT8  bRemanent;
  TLR_UINT8  abTypeOfStation[PNIO_MAX_TYPE_OF_STATION];
} __PACKED_POST PNS_IF_SAVE_STATION_TYPE_IND_DATA_T;

typedef struct PNS_IF_SAVE_STATION_TYPE_IND_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_SAVE_STATION_TYPE_IND_DATA_T       tData;
} PNS_IF_SAVE_STATION_TYPE_IND_T;

/* Response packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_SAVE_STATION_TYPE_RSP_T;

/* packet union */
typedef union PNS_IF_SAVE_STATION_TYPE_PCK_Ttag
{
  PNS_IF_SAVE_STATION_TYPE_IND_T            tInd;
  PNS_IF_SAVE_STATION_TYPE_RSP_T            tRsp;
} PNS_IF_SAVE_STATION_TYPE_PCK_T;


/*
 * SAVE IP ADDRESS SERVICE
 */

/* Indication packet */
typedef __PACKED_PRE struct PNS_IF_SAVE_IP_ADDR_IND_DATA_Ttag
{
  TLR_UINT32  ulIpAddr;
  TLR_UINT32  ulNetMask;
  TLR_UINT32  ulGateway;
  TLR_UINT8   bRemanent;
} __PACKED_POST PNS_IF_SAVE_IP_ADDR_IND_DATA_T;

typedef __PACKED_PRE struct PNS_IF_SAVE_IP_ADDR_IND_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_SAVE_IP_ADDR_IND_DATA_T            tData;
} __PACKED_POST PNS_IF_SAVE_IP_ADDR_IND_T;

/* Response packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_SAVE_IP_ADDR_RSP_T;

/* packet union */
typedef union PNS_IF_SAVE_IP_ADDR_PCK_Ttag
{
  PNS_IF_SAVE_IP_ADDR_IND_T                 tInd;
  PNS_IF_SAVE_IP_ADDR_RSP_T                 tRsp;
} PNS_IF_SAVE_IP_ADDR_PCK_T;


/*
 * APDU STATUS CHANGED SERVICE
 */

/* Indication packet */
typedef __PACKED_PRE struct PNS_IF_APDU_STATUS_CHANGED_IND_DATA_Ttag
{
  TLR_UINT32 hDeviceHandle;
  TLR_UINT32 ulStatus;
} __PACKED_POST PNS_IF_APDU_STATUS_CHANGED_IND_DATA_T;

typedef struct PNS_IF_APDU_STATUS_CHANGED_IND_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_APDU_STATUS_CHANGED_IND_DATA_T     tData;
} PNS_IF_APDU_STATUS_CHANGED_IND_T;

/* Response packet */
typedef PNS_IF_HANDLE_PACKET_T              PNS_IF_APDU_STATUS_CHANGED_RSP_T;

/* packet union */
typedef union PNS_IF_APDU_STATUS_CHANGED_PCK_Ttag
{
  PNS_IF_APDU_STATUS_CHANGED_IND_T          tInd;
  PNS_IF_APDU_STATUS_CHANGED_RSP_T          tRsp;
} PNS_IF_APDU_STATUS_CHANGED_PCK_T;


/*
 * RETURN OF SUBMODULE SERVICE
 */

/* Request packet */
typedef __PACKED_PRE struct PNS_IF_RETURN_OF_SUB_ALARM_REQ_DATA_Ttag
{
  TLR_UINT32  hDeviceHandle;
  TLR_UINT32  ulApi;
  TLR_UINT32  ulSlot;
  TLR_UINT32  ulSubslot;
  TLR_UINT32  hAlarmHandle;
} __PACKED_POST PNS_IF_RETURN_OF_SUB_ALARM_REQ_DATA_T;

typedef struct PNS_IF_RETURN_OF_SUB_ALARM_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_RETURN_OF_SUB_ALARM_REQ_DATA_T     tData;
} PNS_IF_RETURN_OF_SUB_ALARM_REQ_T;

/* Confirmation packet */
typedef __PACKED_PRE struct PNS_IF_RETURN_OF_SUB_ALARM_CNF_DATA_Ttag
{
  TLR_UINT32 hDeviceHandle;
  TLR_UINT32 hAlarmHandle;
  /* Profinet error code, consists of ErrCode, ErrDecode, ErrCode1 and ErrCode2 */
  TLR_UINT32 ulPnio;
} __PACKED_POST PNS_IF_RETURN_OF_SUB_ALARM_CNF_DATA_T;

typedef struct PNS_IF_RETURN_OF_SUB_ALARM_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_RETURN_OF_SUB_ALARM_CNF_DATA_T     tData;
} PNS_IF_RETURN_OF_SUB_ALARM_CNF_T;

/* packet union */
typedef union PNS_IF_RETURN_OF_SUB_ALARM_PCK_Ttag
{
  PNS_IF_RETURN_OF_SUB_ALARM_REQ_T          tReq;
  PNS_IF_RETURN_OF_SUB_ALARM_CNF_T          tCnf;
} PNS_IF_RETURN_OF_SUB_ALARM_PCK_T;


/*
 * LINK STATUS CHANGED SERVICE
 */

/* Indication packet */
typedef __PACKED_PRE struct PNS_IF_LINK_STATUS_CHANGED_IND_DATA_Ttag
{
  PNS_IF_LINK_STATUS_DATA_T  atLinkData[2];
} __PACKED_POST PNS_IF_LINK_STATUS_CHANGED_IND_DATA_T;

typedef struct PNS_IF_LINK_STATUS_CHANGED_IND_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_LINK_STATUS_CHANGED_IND_DATA_T     tData;
} PNS_IF_LINK_STATUS_CHANGED_IND_T;

/* Response packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_LINK_STATUS_CHANGED_RSP_T;

/* packet union */
typedef union PNS_IF_LINK_STATUS_CHANGED_PCK_Ttag
{
  PNS_IF_LINK_STATUS_CHANGED_IND_T          tInd;
  PNS_IF_LINK_STATUS_CHANGED_RSP_T          tRsp;
} PNS_IF_LINK_STATUS_CHANGED_PCK_T;


/*
 * START LED BLINKING SERVICE
 */

/* Indication packet */
typedef __PACKED_PRE struct PNS_IF_START_LED_BLINKING_IND_DATA_Ttag
{
  TLR_UINT32 ulFrequency;
} __PACKED_POST PNS_IF_START_LED_BLINKING_IND_DATA_T;

typedef struct PNS_IF_START_LED_BLINKING_IND_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_START_LED_BLINKING_IND_DATA_T      tData;
} PNS_IF_START_LED_BLINKING_IND_T;

/* Response packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_START_LED_BLINKING_RSP_T;

/* packet union */
typedef union PNS_IF_START_LED_BLINKING_PCK_Ttag
{
  PNS_IF_START_LED_BLINKING_IND_T           tInd;
  PNS_IF_START_LED_BLINKING_RSP_T           tRsp;
} PNS_IF_START_LED_BLINKING_PCK_T;


/*
 * STOP LED BLINKING SERVICE
 */

/* Indication packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_STOP_LED_BLINKING_IND_T;

/* Response packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_STOP_LED_BLINKING_RSP_T;

/* packet union */
typedef union PNS_IF_STOP_LED_BLINKING_PCK_Ttag
{
  PNS_IF_STOP_LED_BLINKING_IND_T            tInd;
  PNS_IF_STOP_LED_BLINKING_RSP_T            tRsp;
} PNS_IF_STOP_LED_BLINKING_PCK_T;


/*
 * GET STATION NAME SERVICE
 */

/* Request packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_GET_STATION_NAME_REQ_T;

/* Confirmation packet */
typedef __PACKED_PRE struct PNS_IF_GET_STATION_NAME_CNF_DATA_Ttag
{
  TLR_UINT16  usNameLen;
  TLR_UINT8   abNameOfStation[PNIO_MAX_NAME_OF_STATION];
} __PACKED_POST PNS_IF_GET_STATION_NAME_CNF_DATA_T;

typedef struct PNS_IF_GET_STATION_NAME_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_GET_STATION_NAME_CNF_DATA_T        tData;
} PNS_IF_GET_STATION_NAME_CNF_T;

/* packet union */
typedef union PNS_IF_GET_STATION_NAME_PCK_Ttag
{
  PNS_IF_GET_STATION_NAME_REQ_T             tReq;
  PNS_IF_GET_STATION_NAME_CNF_T             tCnf;
} PNS_IF_GET_STATION_NAME_PCK_T;


/*
 * GET STATION TYPE SERVICE
 */

/* Request packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_GET_STATION_TYPE_REQ_T;

/* Confirmation packet */
typedef __PACKED_PRE struct PNS_IF_GET_STATION_TYPE_CNF_DATA_Ttag
{
  TLR_UINT16 usTypeLen;
  TLR_UINT8  abTypeOfStation[PNIO_MAX_TYPE_OF_STATION];
} __PACKED_POST PNS_IF_GET_STATION_TYPE_CNF_DATA_T;

typedef struct PNS_IF_GET_STATION_TYPE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_GET_STATION_TYPE_CNF_DATA_T        tData;
} PNS_IF_GET_STATION_TYPE_CNF_T;

/* packet union */
typedef union PNS_IF_GET_STATION_TYPE_PCK_Ttag
{
  PNS_IF_GET_STATION_TYPE_REQ_T             tReq;
  PNS_IF_GET_STATION_TYPE_CNF_T             tCnf;
} PNS_IF_GET_STATION_TYPE_PCK_T;


/*
 * GET IP ADDRESS SERVICE
 */

/* Request packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_GET_IP_ADDR_REQ_T;

/* Confirmation packet */
typedef __PACKED_PRE struct PNS_IF_GET_IP_ADDR_CNF_DATA_Ttag
{
  TLR_UINT32 ulIpAddr;
  TLR_UINT32 ulNetMask;
  TLR_UINT32 ulGateway;
} __PACKED_POST PNS_IF_GET_IP_ADDR_CNF_DATA_T;

typedef struct PNS_IF_GET_IP_ADDR_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_GET_IP_ADDR_CNF_DATA_T             tData;
} PNS_IF_GET_IP_ADDR_CNF_T;

/* packet union */
typedef union PNS_IF_GET_IP_ADDR_PCK_Ttag
{
  PNS_IF_GET_IP_ADDR_REQ_T                  tReq;
  PNS_IF_GET_IP_ADDR_CNF_T                  tCnf;
} PNS_IF_GET_IP_ADDR_PCK_T;


/*
 * REGISTER FATAL ERROR CALLBACK SERVICE
 */

/* Request packet */
typedef __PACKED_PRE struct PNS_REG_FATAL_ERROR_CALLBACK_REQ_DATA_Ttag
{
  PNS_FATAL_ERROR_CLB  pfnClbFnc;
  TLR_VOID*            pvUserParam;
} __PACKED_POST PNS_REG_FATAL_ERROR_CALLBACK_REQ_DATA_T;

typedef struct PNS_REG_FATAL_ERROR_CALLBACK_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_REG_FATAL_ERROR_CALLBACK_REQ_DATA_T   tData;
} PNS_REG_FATAL_ERROR_CALLBACK_REQ_T;

/* Confirmation packet */
typedef TLR_EMPTY_PACKET_T                  PNS_REG_FATAL_ERROR_CALLBACK_CNF_T;

/* packet union */
typedef union PNS_REG_FATAL_ERROR_CALLBACK_PCK_Ttag
{
  PNS_REG_FATAL_ERROR_CALLBACK_REQ_T        tReq;
  PNS_REG_FATAL_ERROR_CALLBACK_CNF_T        tCnf;
} PNS_REG_FATAL_ERROR_CALLBACK_PCK_T;


/*
 * UNREGISTER FATAL ERROR CALLBACK SERVICE
 */

/* Request packet */
typedef TLR_EMPTY_PACKET_T                  PNS_UNREG_FATAL_ERROR_CALLBACK_REQ_T;

/* Confirmation packet */
typedef TLR_EMPTY_PACKET_T                  PNS_UNREG_FATAL_ERROR_CALLBACK_CNF_T;

/* packet union */
typedef union PNS_UNREG_FATAL_ERROR_CALLBACK_PCK_Ttag
{
  PNS_UNREG_FATAL_ERROR_CALLBACK_REQ_T      tReq;
  PNS_UNREG_FATAL_ERROR_CALLBACK_CNF_T      tCnf;
} PNS_UNREG_FATAL_ERROR_CALLBACK_PCK_T;


/*
 * USER ERROR INDICATION SERVICE
 */

/* Indication packet */
typedef __PACKED_PRE struct PNS_IF_USER_ERROR_IND_DATA_Ttag
{
  TLR_UINT32 ulErrorCode;
  TLR_UINT32 ulCommand;
} __PACKED_POST PNS_IF_USER_ERROR_IND_DATA_T;

typedef struct PNS_IF_USER_ERROR_IND_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_USER_ERROR_IND_DATA_T              tData;
} PNS_IF_USER_ERROR_IND_T;

/* Response packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_USER_ERROR_RSP_T;

/* packet union */
typedef union PNS_IF_USER_ERROR_PCK_Ttag
{
  PNS_IF_USER_ERROR_IND_T                   tInd;
  PNS_IF_USER_ERROR_RSP_T                   tRsp;
} PNS_IF_USER_ERROR_PCK_T;


/*
 * GET STACK DIAGNOSIS SERVICE
 */

typedef enum PNS_IF_STATE_DEFINITIONS_Ttag {
  PNS_IF_STATE_UNCONFIGURED          = 0x00000000,
  PNS_IF_STATE_DEVICEINFO_SET        = 0x00000001,     /* basic information set inside the stack? */
  PNS_IF_STATE_STACK_STARTED         = 0x00000002,     /* stack was started and is running? */
  PNS_IF_STATE_RESERVED1             = 0x00000004,
  PNS_IF_STATE_API_PRESENT           = 0x00000008,     /* at least one api present */
  PNS_IF_STATE_MOD0_PRESENT          = 0x00000010,
  PNS_IF_STATE_MOD0SUB1_PRESENT      = 0x00000020,
  PNS_IF_STATE_BUS_ON                = 0x00000040,     /* Bus ON was set by application? */
  PNS_IF_STATE_COMMUNICATING         = 0x00000080,     /* stack is in cyclic communication? */
  PNS_IF_STATE_CONFIG_LOCKED         = 0x00000100,     /* the configuration was locked by application */
  PNS_IF_STATE_FATAL_ERROR_OCCURRED  = 0x00000200,     /* a fatal error occurred */
  PNS_IF_STATE_DIAGNOSIS_PRESENT     = 0x00000400,     /* a Profinet diagnosis record exists at stack level */
  PNS_IF_STATE_MAINTENANCE_REQUIRED  = 0x00000800,     /* a Profinet maintenance required record is pending */
  PNS_IF_STATE_MAINTENANCE_DEMANDED  = 0x00001000,     /* a Profinet maintenance demanded record is pending */
  PNS_IF_STATE_FO_MAINT_DEM_PORT_0   = 0x00002000,     /* a Profinet FiberOptic Maintenance demanded record exists for Port 0 */
  PNS_IF_STATE_FO_MAINT_REQ_PORT_0   = 0x00004000,     /* a Profinet FiberOptic Maintenance required record exists for Port 0 */
  PNS_IF_STATE_FO_MAINT_DEM_PORT_1   = 0x00008000,     /* a Profinet FiberOptic Maintenance demanded record exists for Port 1 */
  PNS_IF_STATE_FO_MAINT_REQ_PORT_1   = 0x00010000      /* a Profinet FiberOptic Maintenance required record exists for Port 1 */
} PNS_IF_STATE_DEFINITIONS;

typedef enum PNS_IF_LINKSTATES_Ttag {
  PNS_IF_LINK_STATE_LINK             = 0x00000001,
  PNS_IF_LINK_STATE_LOWSPEED         = 0x00000002,
  PNS_IF_LINK_STATE_NOLINK           = 0x00000003
} PNS_IF_LINKSTATES_T;

typedef enum PNS_IF_CONFIG_STATES_Ttag {
  PNS_IF_CONFIG_STATE_UNCONFIGURED   = 0,
  PNS_IF_CONFIG_STATE_DBM,
  PNS_IF_CONFIG_STATE_DBM_ERROR,
  PNS_IF_CONFIG_STATE_APPL,
  PNS_IF_CONFIG_STATE_APPL_RUNNING,
  PNS_IF_CONFIG_STATE_APPL_ERROR,
  PNS_IF_CONFIG_STATE_WARMSTART,
  PNS_IF_CONFIG_STATE_WARMSTART_RUNNING,
  PNS_IF_CONFIG_STATE_WARMSTART_ERROR
} PNS_IF_CONFIG_STATES_T;


/* Request packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_GET_DIAGNOSIS_REQ_T;

/* Confirmation packet */
typedef __PACKED_PRE struct PNS_IF_STATUS_Ttag
{
  TLR_UINT32      ulPnsState;
  TLR_UINT32      ulLastRslt;
  TLR_UINT32      ulLinkState;
  TLR_UINT32      ulConfigState;
  TLR_UINT32      ulCommunicationState;
  TLR_UINT32      ulCommunicationError;
} __PACKED_POST PNS_IF_STATUS_T;

typedef struct PNS_IF_GET_DIAGNOSIS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_STATUS_T                           tData;
} PNS_IF_GET_DIAGNOSIS_CNF_T;

/* packet union */
typedef union PNS_IF_GET_DIAGNOSIS_PCK_Ttag
{
  PNS_IF_GET_DIAGNOSIS_REQ_T                tReq;
  PNS_IF_GET_DIAGNOSIS_CNF_T                tCnf;
} PNS_IF_GET_DIAGNOSIS_PCK_T;


/*
 * Get XMAC (EDD) diagnosis Request
 */

typedef __PACKED_PRE struct {
  /* count of frames that are successfully transmitted */
  TLR_UINT32 ulFramesTransmittedOk;
  /* count of frames that are involved into a single collision */
  TLR_UINT32 ulSingleCollisionFrames;
  //count of frames that are involved into more that one collisions
  TLR_UINT32 ulMultipleCollisionFrames;
  /* later than 512 bit times into the transmitted packet */
  TLR_UINT32 ulLateCollisions;
  /* count of the times that a frame was transmitted during link down */
  TLR_UINT32 ulLinkDownDuringTransmission;
  /* utx fifo underflow at transmission time */
  TLR_UINT32 ulUtxUnderflowDuringTransmission;
  /* wrong tpu error code, shall always be zero */
  TLR_UINT32 ulTxFatalErrors;
  /* count of frames that are successfully received */
  TLR_UINT32 ulFramesReceivedOk;
  /* count of frames that are an integral number of octets */
  /* in length and do not pass the FCS check */
  TLR_UINT32 ulFrameCheckSequenceErrors;
  /* count of frames that are not an integral number of octets */
  /* in length and do not pass the FCS check */
  TLR_UINT32 ulAlignmentErrors;
  /* count of frames that are received and exceed the maximum permitted frame size */
  TLR_UINT32 ulFrameTooLongErrors;
  /* count of frames that have a length between 42..63 bytes and a valid CRC */
  TLR_UINT32 ulRuntFramesReceived;
  /* count of frames that are smaller that 64 bytes and have a invalid CRC */
  TLR_UINT32 ulCollisionFragmentsReceived;
  /* no empty pointer available at indication time */
  TLR_UINT32 ulFramesDroppedDueLowResource;
  /* urx fifo overflow at indication time */
  TLR_UINT32 ulFramesDroppedDueUrxOverflow;
  /* wrong rpu error code, shall always be zero */
  TLR_UINT32 ulRxFatalErrors;
} __PACKED_POST EDD_XMAC_COUNTERS_T;

/* request packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_GET_XMAC_DIAGNOSIS_REQ_T;

/* confirmation packet */
typedef __PACKED_PRE struct PNS_IF_GET_XMAC_DIAGNOSIS_DATA_Ttag
{
  EDD_XMAC_COUNTERS_T tXMACCounters[2];
} __PACKED_POST PNS_IF_GET_XMAC_DIAGNOSIS_DATA_T;

typedef __PACKED_PRE struct PNS_IF_GET_XMAC_DIAGNOSIS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_GET_XMAC_DIAGNOSIS_DATA_T          tData;
} __PACKED_POST PNS_IF_GET_XMAC_DIAGNOSIS_CNF_T;

/* packet union */

typedef union
{
  PNS_IF_GET_XMAC_DIAGNOSIS_REQ_T tReq;
  PNS_IF_GET_XMAC_DIAGNOSIS_CNF_T tCnf;
} PNS_IF_GET_XMAC_DIAGNOSIS_PCK_T ;

/*
 * SET PORT MAC ADDRESS SERVICE
 */

/* Request packet */
typedef TLR_UINT8 PORT_MAC_ADDR_T[6];

typedef __PACKED_PRE struct PNS_IF_SET_PORT_MAC_REQ_DATA_Ttag
{
  PORT_MAC_ADDR_T atPortMacAddr[2];
} __PACKED_POST PNS_IF_SET_PORT_MAC_REQ_DATA_T;

typedef struct PNS_IF_SET_PORT_MAC_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_SET_PORT_MAC_REQ_DATA_T            tData;
} PNS_IF_SET_PORT_MAC_REQ_T;

/* Confirmation packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_SET_PORT_MAC_CNF_T;

/* packet union */
typedef union PNS_IF_SET_PORT_MAC_PCK_Ttag
{
  PNS_IF_SET_PORT_MAC_REQ_T                tReq;
  PNS_IF_SET_PORT_MAC_CNF_T                tCnf;
} PNS_IF_SET_PORT_MAC_PCK_T;


/*
 * RESET  FACTORY SETTINGS SERVICE FROM STACK
 */

/* Indication packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_RESET_FACTORY_SETTINGS_IND_T;

/* Response packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_RESET_FACTORY_SETTINGS_RSP_T;

/* packet union */
typedef union PNS_IF_RESET_FACTORY_SETTINGS_PCK_Ttag
{
  PNS_IF_RESET_FACTORY_SETTINGS_IND_T       tInd;
  PNS_IF_RESET_FACTORY_SETTINGS_RSP_T       tRsp;
} PNS_IF_RESET_FACTORY_SETTINGS_PCK_T;


/*
 * RESET  FACTORY SETTINGS SERVICE FROM APPLICATION
 */

/* Request packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_RESET_FACTORY_SETTINGS_REQ_T;

/* Confirmation packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_RESET_FACTORY_SETTINGS_CNF_T;

/* packet union */
typedef union PNS_IF_RESET_FACTORY_SETTINGS_APP_PCK_Ttag
{
  PNS_IF_RESET_FACTORY_SETTINGS_REQ_T       tReq;
  PNS_IF_RESET_FACTORY_SETTINGS_CNF_T       tCnf;
} PNS_IF_RESET_FACTORY_SETTINGS_APP_PCK_T;



/*
 * ABORT CONNECTION SERVICE
 */

/* Request packet */
typedef PNS_IF_HANDLE_PACKET_T              PNS_IF_ABORT_CONNECTION_REQ_T;

/* Confirmation packet */
typedef PNS_IF_HANDLE_PACKET_T              PNS_IF_ABORT_CONNECTION_CNF_T;

/* packet union */
typedef union PNS_IF_ABORT_CONNECTION_PCK_Ttag
{
  PNS_IF_ABORT_CONNECTION_REQ_T             tReq;
  PNS_IF_ABORT_CONNECTION_CNF_T             tCnf;
} PNS_IF_ABORT_CONNECTION_PCK_T;

/*
 * SET OEM PARAMETER SERVICE
 */

#define PNS_IF_SET_OEM_PARAMETERS_TYPE_1          0x01
#define PNS_IF_SET_OEM_PARAMETERS_TYPE_2          0x02
#define PNS_IF_SET_OEM_PARAMETERS_TYPE_6          0x06

/* Request packet */
typedef __PACKED_PRE struct PNS_IF_SET_OEM_PARAMETERS_TYPE_1_Ttag
{
  TLR_UINT8  abSerialNumber[16];
  TLR_UINT16 usProfileId;
  TLR_UINT16 usRevisionCounter;
  TLR_UINT16 usProfileSpecificType;
} __PACKED_POST PNS_IF_SET_OEM_PARAMETERS_TYPE_1_T;

typedef __PACKED_PRE struct PNS_IF_SET_OEM_PARAMETERS_TYPE_2_Ttag
{
  TLR_UINT8  abSerialNumber[16];
} __PACKED_POST PNS_IF_SET_OEM_PARAMETERS_TYPE_2_T;

typedef __PACKED_PRE struct PNS_IF_SET_OEM_PARAMETERS_TYPE_6_Ttag
{
  TLR_UINT16  usIRTCycleCounterOffset;
} __PACKED_POST PNS_IF_SET_OEM_PARAMETERS_TYPE_6_T;

typedef __PACKED_PRE struct PNS_IF_SET_OEM_PARAMETERS_REQ_DATA_Ttag
{
  TLR_UINT32 ulParameterType;
} __PACKED_POST PNS_IF_SET_OEM_PARAMETERS_REQ_DATA_T;

typedef __PACKED_PRE union PNS_IF_SET_OEM_PARAMETERS_UNION_Ttag
{
  PNS_IF_SET_OEM_PARAMETERS_TYPE_1_T      tType1Param;
  PNS_IF_SET_OEM_PARAMETERS_TYPE_2_T      tType2Param;
  PNS_IF_SET_OEM_PARAMETERS_TYPE_6_T      tType6Param;
} __PACKED_POST PNS_IF_SET_OEM_PARAMETERS_UNION_T;

typedef struct PNS_IF_SET_OEM_PARAMETERS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_SET_OEM_PARAMETERS_REQ_DATA_T      tData;
  PNS_IF_SET_OEM_PARAMETERS_UNION_T         tParam;
} PNS_IF_SET_OEM_PARAMETERS_REQ_T;

/* Confirmation packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_SET_OEM_PARAMETERS_CNF_T;

/* packet union */
typedef union PNS_IF_SET_OEM_PARAMETERS_PCK_Ttag
{
  PNS_IF_SET_OEM_PARAMETERS_REQ_T           tReq;
  PNS_IF_SET_OEM_PARAMETERS_CNF_T           tCnf;
} PNS_IF_SET_OEM_PARAMETERS_PCK_T;

/*
 * STORE REMANENT DATA SERVICE -> used to indicate data to be stored
 */

/* Indication packet */
typedef __PACKED_PRE struct PNS_IF_STORE_REMANENT_DATA_IND_DATA_Ttag
{
  /** this is only the first byte, many others may follow */
  TLR_UINT8  abData[1];
} __PACKED_POST PNS_IF_STORE_REMANENT_DATA_IND_DATA_T;

typedef struct PNS_IF_STORE_REMANENT_DATA_IND_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_STORE_REMANENT_DATA_IND_DATA_T     tData;
} PNS_IF_STORE_REMANENT_DATA_IND_T;

/* Response packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_STORE_REMANENT_DATA_RES_T;

/* packet union */
typedef union PNS_IF_STORE_REMANENT_DATA_PCK_Ttag
{
  PNS_IF_STORE_REMANENT_DATA_IND_T          tInd;
  PNS_IF_STORE_REMANENT_DATA_RES_T          tRes;
} PNS_IF_STORE_REMANENT_DATA_PCK_T;

/*
 * LOAD REMANENT DATA SERVICE -> used to load remanent data back into the stack
 */

/* request packet */
typedef __PACKED_PRE struct
{
  /** this is only the first byte, many others may follow */
  TLR_UINT8  abData[1];
} __PACKED_POST PNS_IF_LOAD_REMANENT_DATA_REQ_DATA_T;

typedef __PACKED_PRE struct
{
  TLR_PACKET_HEADER_T                       tHead;
  PNS_IF_LOAD_REMANENT_DATA_REQ_DATA_T      tData;
} __PACKED_POST PNS_IF_LOAD_REMANENT_DATA_REQ_T;

/* Response packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_LOAD_REMANENT_DATA_CNF_T;

/* packet union */
typedef union PNS_IF_LOAD_REMANENT_DATA_PCK_Ttag
{
  PNS_IF_LOAD_REMANENT_DATA_REQ_T          tReq;
  PNS_IF_LOAD_REMANENT_DATA_CNF_T          tCnf;
} PNS_IF_LOAD_REMANENT_DATA_PCK_T;


/*
 * WARMSTART SERVICE  with autoconfiguration
 */

/* ATTENTION: It is NOT recommended to use this service */
/* Using it will make the stack automatically adapt its module configuration */
/* to the configuration expected by IO-Controller. */
/* The stack will internally plug all modules and calculate the DPM-offsets */
/* starting at offset 0 the offsets will be ascending according to the slot and subslot */
/* the user will NOT have any information about the modules and datatypes behind them */
/* the user will only see the total amount of IO-Data */

#define PNS_IF_GSDML_SLOT0_MODULEID                  1
#define PNS_IF_GSDML_SLOT0_SUBSLOT1_SUBMODULEID      0
#define PNS_IF_GSDML_SLOT0_SUBSLOT8000_SUBMODULEID   1
#define PNS_IF_GSDML_SLOT0_SUBSLOT8001_SUBMODULEID   2
#define PNS_IF_GSDML_SLOT0_SUBSLOT8002_SUBMODULEID   3
#define PNS_IF_GSDML_INSTANCE_ID                     1

#define PNS_IF_DEFAULT_DIAG_RECORD_AMOUNT            256

/* request packet */
typedef __PACKED_PRE struct __PACKED_POST PNS_IF_SET_WARMSTART_REQ_DATA_Ttag
{
  /* communication start mode (PNS_IF_SYSTEM_START_AUTO_START, PNS_IF_SYSTEM_START_APPL_CONTROLLED) */
  /* Data Status PNS_IF_SYSTEM_DATA_STA_ENABLED/DISABLED, PNS_IF_SYSTEM_LONG_DATA_STA_ENABLED/DISABLED */
  TLR_UINT32  ulSystemFlags;
  /* DPM watchdog time */
  TLR_UINT32  ulWdgTime;
  /* vendor id */
  TLR_UINT32  ulVendorId;
  /* device id */
  TLR_UINT32  ulDeviceId;
  /* max number of AR */
  TLR_UINT32  ulMaxAr;
  /* complete input size */
  TLR_UINT32  ulCompleteInputSize;
  /* complete output size */
  TLR_UINT32  ulCompleteOutputSize;
  /* name of station length */
  TLR_UINT32  ulNameOfStationLen;
  /* name of station  */
  TLR_UINT8   abNameOfStation[PNIO_MAX_NAME_OF_STATION];
  /* type of station length */
  TLR_UINT32  ulTypeOfStationLen;
  /* type of station  */
  TLR_UINT8   abTypeOfStation[PNIO_MAX_TYPE_OF_STATION];
  /* device type */
  TLR_UINT8   abDeviceType[PNS_IF_MAX_DEVICE_TYPE_LEN + 3]; //  +3 to avoid not DWORD aligned access
  /* order id */
  TLR_UINT8   abOrderId[PNIO_MAX_ORDER_ID];
  /* Ip Addr */
  TLR_UINT32  ulIpAddr;
  /* Subnetwork mask */
  TLR_UINT32  ulSubnetworkMask;
  /* gateway address */
  TLR_UINT32  ulGateway;

} __PACKED_POST PNS_IF_SET_WARMSTART_REQ_DATA_T;

typedef __PACKED_PRE struct __PACKED_POST PNS_IF_SET_WARMSTART_REQ_Ttag
{
  TLR_PACKET_HEADER_T                      tHead;
  PNS_IF_SET_WARMSTART_REQ_DATA_T          tData;

} PNS_IF_SET_WARMSTART_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T                  PNS_IF_SET_WARMSTART_CNF_T;

/* packet union */
typedef union PNS_IF_SET_WARMSTART_PCK_Ttag
{
  PNS_IF_SET_WARMSTART_REQ_T               tReq;
  PNS_IF_SET_WARMSTART_CNF_T               tCnf;
} PNS_IF_SET_WARMSTART_PCK_T;

/**
 * Set IO Image Service
 */
typedef enum PNS_IF_IO_EVENT_Etag
{
  PNS_IF_IO_EVENT_RESERVED                    = 0x00000000,
  PNS_IF_IO_EVENT_NEW_FRAME                   = 0x00000001,
  PNS_IF_IO_EVENT_CONSUMER_UPDATE_REQUIRED    = 0x00000002,
  PNS_IF_IO_EVENT_PROVIDER_UPDATE_REQUIRED    = 0x00000003,
} PNS_IF_IO_EVENT_E;

typedef TLR_RESULT (*PNS_IF_UPDATE_IOIMAGE_CLB_T)     (TLR_HANDLE hUserParam, TLR_UINT uiTimeout, TLR_UINT uiReserved1, TLR_UINT uiReserved2);
typedef TLR_RESULT (*PNS_IF_UPDATE_EXTSTA_BLOCK_CLB_T)(TLR_HANDLE hUserParam, PNS_IF_EXTENDED_STATUS_BLOCK_T* ptExtSta);
typedef TLR_RESULT (*PNS_IF_IOEVENT_HANDLER_CLB_T)    (TLR_HANDLE hUserParam, TLR_UINT uiEvents);

typedef __PACKED_PRE struct PNS_IF_SET_IOIMAGE_REQ_DATA_Ttag
{
  TLR_UINT32                        ulConsImageSize;
  TLR_UINT32                        ulProvImageSize;
  TLR_UINT8*                        pbConsImage;
  TLR_UINT8*                        pbProvImage;

  PNS_IF_IOEVENT_HANDLER_CLB_T      pfnEventHandler;
  TLR_HANDLE                        hUserParam;

} __PACKED_POST PNS_IF_SET_IOIMAGE_REQ_DATA_T;

typedef __PACKED_PRE struct  PNS_IF_SET_IOIMAGE_CNF_DATA_Ttag
{
  TLR_HANDLE                        hCallbackParam;
  PNS_IF_UPDATE_IOIMAGE_CLB_T       pfnUpdateConsumerImage;
  PNS_IF_UPDATE_IOIMAGE_CLB_T       pfnUpdateProviderImage;
  PNS_IF_UPDATE_EXTSTA_BLOCK_CLB_T  pfnUpdateExtStaBlock;
} __PACKED_POST PNS_IF_SET_IOIMAGE_CNF_DATA_T;

typedef __PACKED_PRE struct PNS_IF_SET_IOIMAGE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  PNS_IF_SET_IOIMAGE_REQ_DATA_T       tData;
} __PACKED_POST PNS_IF_SET_IOIMAGE_REQ_T;

typedef __PACKED_PRE struct PNS_IF_SET_IOIMAGE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  PNS_IF_SET_IOIMAGE_CNF_DATA_T       tData;
} __PACKED_POST PNS_IF_SET_IOIMAGE_CNF_T;

typedef union PNS_IF_SET_IOIMAGE_PCK_Ttag
{
  PNS_IF_SET_IOIMAGE_REQ_T            tReq;
  PNS_IF_SET_IOIMAGE_CNF_T            tCnf;
} PNS_IF_SET_IOIMAGE_PCK_T;

/**
 * Set IOXS CONFIG request
 */

typedef enum PNS_IF_IOPS_MODE_Etag
{
  PNS_IF_IOPS_DISABLED = 0,
  PNS_IF_IOPS_BITWISE,
  PNS_IF_IOPS_BYTEWISE,
} PNS_IF_IOPS_MODE_E;

typedef enum PNS_IF_IOCS_MODE_Etag
{
  PNS_IF_IOCS_DISABLED = 0,
} PNS_IF_IOCS_MODE_E;

typedef __PACKED_PRE struct PNS_IF_SET_IOXS_CONFIG_DATA_Ttag
{
  TLR_UINT32    ulConsImageIOPSMode;
  TLR_UINT32    ulConsImageIOPSOffset;
  TLR_UINT32    ulProvImageIOPSMode;
  TLR_UINT32    ulProvImageIOPSOffset;

  TLR_UINT32    ulConsImageIOCSMode;
  TLR_UINT32    ulConsImageIOCSOffset;
  TLR_UINT32    ulProvImageIOCSMode;
  TLR_UINT32    ulProvImageIOCSOffset;
} __PACKED_POST PNS_IF_SET_IOXS_CONFIG_DATA_T;

typedef __PACKED_PRE struct PNS_IF_SET_IOXS_CONFIG_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  PNS_IF_SET_IOXS_CONFIG_DATA_T   tData;
} __PACKED_POST PNS_IF_SET_IOXS_CONFIG_REQ_T ;

typedef __PACKED_PRE struct PNS_IF_SET_IOXS_CONFIG_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
} __PACKED_POST PNS_IF_SET_IOXS_CONFIG_CNF_T ;

typedef union PNS_IF_SET_IOXS_CONFIG_PCK_Ttag
{
  PNS_IF_SET_IOXS_CONFIG_REQ_T           tReq;
  PNS_IF_SET_IOXS_CONFIG_CNF_T           tCnf;
} PNS_IF_SET_IOXS_CONFIG_PCK_T ;


/**
 * Configure Signal request
 */

/** Only define the fieldbus specific part of tData here.
 * See IOSignals_Public for the whole packet
 */
typedef __PACKED_PRE struct PNS_IF_CONFIGURE_SIGNAL_REQ_DATA_HEAD_Ttag
{
  /** Usually here is the device handle, we dont need it for this request,
   *  just to have the same layout. Set to Zero */
  TLR_UINT32  ulReserved1;
  /** Api of the submodule the io signal configuration is for. */
  TLR_UINT32  ulApi;
  /** Slot of the submodule the io signal configuration is for. */
  TLR_UINT32  ulSlot;
  /** Subslot of the submodule the io signal configuration is for. */
  TLR_UINT32  ulSubslot;
  /** Unused for Profinet device stack. Set to Zero.*/
  TLR_UINT32  ulReserved2;
  /** Unused for Profinet device stack. Set to Zero.*/
  TLR_UINT32  ulReserved3;
  /** Unused for Profinet device stack. Set to Zero.*/
  TLR_UINT32  ulReserved4;
  /** Unused for Profinet device stack. Set to Zero.*/
  TLR_UINT32  ulReserved5;
} __PACKED_POST PNS_IF_CONFIGURE_SIGNAL_REQ_DATA_HEAD_T;



/*
 * @defgroup im_requests I&M Related Requests
 *
 * @{
 */

/**
 * @brief I&M0 Filter Data Structure
 */
typedef enum
{
  PNS_IF_IM0_FILTER_DATA_HAS_IM_DATA = 0x00000001, /**> The submodule has discrete I&M Data */
  PNS_IF_IM0_FILTER_DATA_MODULE_REF  = 0x00000002, /**> The submodule represents the whole module in terms of I&M */
  PNS_IF_IM0_FILTER_DATA_DEVICE_REF  = 0x00000004, /**> The submodule represents the whole device in terms of I&M */
} PNS_IF_IM0_FILTER_DATA_FLAGS_E;

typedef __PACKED_PRE struct PNS_IF_IM0_FILTER_DATA_Ttag
{
  /** api of the module */
  TLR_UINT32    ulApi;
  /** slot of the module */
  TLR_UINT16    usSlot;
  /** subslot of the module */
  TLR_UINT16    usSubslot;
  /** Flags (if ulFlags == 0 module shall be omitted) */
  TLR_UINT32    ulFlags;
} __PACKED_POST PNS_IF_IM0_FILTER_DATA_T;

/**
 * @brief I&M0 Data Structure
 *
 */
typedef __PACKED_PRE struct PNS_IF_IM0_DATA_Ttag
{
  /** Unused on Profinet, set to zero */
  TLR_UINT8   abManufacturerSpecific[10];
  /** Manufacturer ID as assigned by PNIO/PROFIBUS office */
  TLR_UINT16  usManufacturerId;
  /** Order ID. (Space(0x20) padded) */
  TLR_UINT8   abOrderId[20];
  /** Serial number (Space(0x20) padded) */
  TLR_UINT8   abSerialNumber[16];
  /** Hardware revision */
  TLR_UINT16  usHardwareRevision;
  /** Software revision PrefixX.Y.Z*/
  struct {
    /** Type Recogninition / Prefix
     *
     * Allowed values:
     * -# 'V' officially released version
     * -# 'R' Revision
     * -# 'P' Prototype
     * -# 'U' Under Test (field test)
     * -# 'T' Test Device
     */
    TLR_UINT8 bPrefix;
    /** Functional enhancement */
    TLR_UINT8 bX;
    /** Bug fix */
    TLR_UINT8 bY;
    /** Internal change */
    TLR_UINT8 bZ;
  } tSoftwareRevision;
  /** Revision counter
   *
   * To be incremented on each change of hardware or
   * parameter change*/
  TLR_UINT16  usRevisionCounter;
  /** Profile ID (default 0xF600)*/
  TLR_UINT16  usProfileId;
  /** Profile specific type (optional)*/
  TLR_UINT16  usProfileSpecificType;
  /** I&M Version */
  TLR_UINT16  usIMVersion;
  /** I&M Supported
   *
   * -# Bit 0: Profile specific I&M
   * -# Bit 1: I&M 1 supported
   * -# Bit 2: I&M 2 supported
   * -# Bit 3: I&M 3 supported
   * -# Bit 4: I&M 4 supported
   * -# .... (Remaining I&M reserved)
   * */
  TLR_UINT16  usIMSupported;
} __PACKED_POST PNS_IF_IM0_DATA_T;

/**
 * @brief I&M1 Data Structure
 */
typedef __PACKED_PRE struct PNS_IF_IM1_DATA_Ttag
{
  /** Unused on Profinet, set to zero */
  TLR_UINT8   abManufacturerSpecific[10];
  /** TAG-Function. (space(0x20) padded)
   * Default: Filled with 0x20 (space)
   * */
  TLR_UINT8   abTagFunction[32];
  /** TAG-Location. (space(0x20) padded)
   * Default: Filled with 0x20 (space)
   * */
  TLR_UINT8   abTagLocation[22];
}__PACKED_POST PNS_IF_IM1_DATA_T;

/**
 * @brief I&M2 Data Structure
 */
typedef __PACKED_PRE struct PNS_IF_IM2_DATA_Ttag
{
  /** Unused on Profinet, set to zero */
  TLR_UINT8   abManufacturerSpecific[10];
  /** Installation Date (space(0x20) padded)
   *
   * Default: Filled with 0x20 (space)
   * Format:
   * -# YYYY-MM-DD or
   * -# YYYY-MM-DD hh::mm
   * */
  TLR_UINT8   abInstallationDate[16];
  /** Reserved, set to zero */
  TLR_UINT8   abReserved[38];

}__PACKED_POST PNS_IF_IM2_DATA_T;

/**
 * @brief I&M3 Data Structure
 */
typedef __PACKED_PRE struct PNS_IF_IM3_DATA_Ttag
{
  /** Unused on Profinet, set to zero */
  TLR_UINT8   abManufacturerSpecific[10];
  /** Descriptor (Comment). (space(0x20) padded)
   * Default: Filled with 0x20 (space)
   * */
  TLR_UINT8   abDescriptor[54];
}__PACKED_POST PNS_IF_IM3_DATA_T;

/**
 * @brief I&M4 Data Structure
 */
typedef __PACKED_PRE struct PNS_IF_IM4_DATA_Ttag
{
  /** Unused on Profinet, set to zero */
  TLR_UINT8   abManufacturerSpecific[10];
  /** Signature. (space(0x20) padded)
   * Default: Filled with 0x00 (zero)
   * */
  TLR_UINT8   abSignature[54];
}__PACKED_POST PNS_IF_IM4_DATA_T;


/**
 * Read I&M service
 */
typedef enum
{
  PNS_IF_IM_TYPE_IM0       = 0,
  PNS_IF_IM_TYPE_IM1       = 1,
  PNS_IF_IM_TYPE_IM2       = 2,
  PNS_IF_IM_TYPE_IM3       = 3,
  PNS_IF_IM_TYPE_IM4       = 4,
  PNS_IF_IM_TYPE_IM0FILTER = 255,
} PNS_IF_IM_TYPE_E;

typedef __PACKED_PRE struct PNS_IF_READ_IM_IND_DATA_Ttag
{
  /** api of the submodule the i&m data shall be read from */
  TLR_UINT32    ulApi;
  /** slot of the submodule the i&m data shall be read from */
  TLR_UINT16    usSlot;
  /** subslot of the submodule the i&m data shall be read from */
  TLR_UINT16    usSubslot;
  /** type of i&m to read */
  TLR_UINT8     bIMType;
  /** unused */
  TLR_UINT8     abReserved[3];
} __PACKED_POST PNS_IF_READ_IM_IND_DATA_T;

typedef __PACKED_PRE struct PNS_IF_READ_IM_RES_DATA_Ttag
{
  /** api of the submodule the i&m data shall be read from */
  TLR_UINT32    ulApi;
  /** slot of the submodule the i&m data shall be read from */
  TLR_UINT16    usSlot;
  /** subslot of the submodule the i&m data shall be read from */
  TLR_UINT16    usSubslot;
  /** type of i&m read */
  TLR_UINT8     bIMType;
  /* unused, set to zero */
  TLR_UINT8     abReserved[3];
  /** union of I&M Data */
  union {
    /** Array of submodules describing I&M state of submodules
     * ( grow Array as required)*/
    PNS_IF_IM0_FILTER_DATA_T  atIM0FilterData[1];
    /** I&M0 Data */
    PNS_IF_IM0_DATA_T         tIM0;
    /** I&M1 Data */
    PNS_IF_IM1_DATA_T         tIM1;
    /** I&M2 Data */
    PNS_IF_IM2_DATA_T         tIM2;
    /** I&M3 Data */
    PNS_IF_IM3_DATA_T         tIM3;
    /** I&M4 Data */
    PNS_IF_IM4_DATA_T         tIM4;
  } tData;
} __PACKED_POST PNS_IF_READ_IM_RES_DATA_T;


typedef struct PNS_IF_READ_IM_IND_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T         tHead;
  /** packet data */
  PNS_IF_READ_IM_IND_DATA_T   tData;
} PNS_IF_READ_IM_IND_T;

typedef struct PNS_IF_READ_IM_RES_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T         tHead;
  /** packet data */
  PNS_IF_READ_IM_RES_DATA_T   tData;
} PNS_IF_READ_IM_RES_T;

typedef union PNS_IF_READ_IM_PCK_Ttag
{
  /** indication */
  PNS_IF_READ_IM_IND_T        tInd;
  /** response */
  PNS_IF_READ_IM_RES_T        tRsp;
} PNS_IF_READ_IM_PCK_T;

/*
 * Write I&M Service
 */
typedef __PACKED_PRE struct PNS_IF_WRITE_IM_IND_DATA_Ttag
{
  /** api of the submodule the i&m data shall be read from */
  TLR_UINT32    ulApi;
  /** slot of the submodule the i&m data shall be read from */
  TLR_UINT16    usSlot;
  /** subslot of the submodule the i&m data shall be read from */
  TLR_UINT16    usSubslot;
  /** type of i&m to write */
  TLR_UINT8     bIMType;
  /* unused, set to zero */
  TLR_UINT8     abReserved[3];
  /** union of I&M Data */
  union {
    /** I&M1 Data */
    PNS_IF_IM1_DATA_T         tIM1;
    /** I&M2 Data */
    PNS_IF_IM2_DATA_T         tIM2;
    /** I&M3 Data */
    PNS_IF_IM3_DATA_T         tIM3;
    /** I&M4 Data */
    PNS_IF_IM4_DATA_T         tIM4;
  } tData;
} __PACKED_POST PNS_IF_WRITE_IM_IND_DATA_T;

typedef __PACKED_PRE struct PNS_IF_WRITE_IM_RES_DATA_Ttag
{
  /** api of the submodule the i&m data shall be read from */
  TLR_UINT32    ulApi;
  /** slot of the submodule the i&m data shall be read from */
  TLR_UINT16    usSlot;
  /** subslot of the submodule the i&m data shall be read from */
  TLR_UINT16    usSubslot;
  /** type of i&m written */
  TLR_UINT8     bIMType;
  /* unused, set to zero */
  TLR_UINT8     abReserved[3];
} __PACKED_POST PNS_IF_WRITE_IM_RES_DATA_T;


typedef struct PNS_IF_WRITE_IM_IND_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T         tHead;
  /** packet data */
  PNS_IF_WRITE_IM_IND_DATA_T  tData;
} PNS_IF_WRITE_IM_IND_T;

typedef struct PNS_IF_WRITE_IM_RES_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T         tHead;
  /** packet data */
  PNS_IF_WRITE_IM_RES_DATA_T  tData;
} PNS_IF_WRITE_IM_RES_T;

typedef union PNS_IF_WRITE_IM_PCK_Ttag
{
  /** indication */
  PNS_IF_WRITE_IM_IND_T       tInd;
  /** response */
  PNS_IF_WRITE_IM_RES_T       tRsp;
} PNS_IF_WRITE_IM_PCK_T;


/**
 * Parameterization Speedup Supported Indication to application
 */

typedef struct FSUUID_Ttag   FSUUID_T;

__PACKED_PRE
struct  FSUUID_Ttag           /* UUID data */
{
  /** 00:04, uuid data 1, 32Bit */
  TLR_UINT32        ulData1;
  /** 04:02, uuid data 2, 16Bit */
  TLR_UINT16        usData2;
  /** 06:02, uuid data 3, 16Bit */
  TLR_UINT16        usData3;
  /** 08:08, uuid data 4, 8x8Bit */
  TLR_UINT8         abData4[8];
} __PACKED_POST;

typedef __PACKED_PRE struct PNS_IF_PARAMET_SPEEDUP_SUPPORTED_IND_DATA_Ttag
{
  /** received UUID send to application */
  FSUUID_T tFSUuid;

} __PACKED_POST PNS_IF_PARAMET_SPEEDUP_SUPPORTED_IND_DATA_T;


typedef struct PNS_IF_PARAMET_SPEEDUP_SUPPORTED_IND_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                           tHead;
  /** packet data */
  PNS_IF_PARAMET_SPEEDUP_SUPPORTED_IND_DATA_T   tData;
} PNS_IF_PARAMET_SPEEDUP_SUPPORTED_IND_T;

typedef TLR_EMPTY_PACKET_T   PNS_IF_PARAMET_SPEEDUP_SUPPORTED_RES_T;


typedef union PNS_IF_PARAMET_SPEEDUP_SUPPORTED_PCK_Ttag
{
  /** indication */
  PNS_IF_PARAMET_SPEEDUP_SUPPORTED_IND_T        tInd;
  /** response */
  PNS_IF_PARAMET_SPEEDUP_SUPPORTED_RES_T        tRsp;
} PNS_IF_PARAMET_SPEEDUP_SUPPORTED_PCK_T;

/**
 * Set Submodule state Service
 */
/* the submodule is locked by application */
/* not yet supported by the stack, for future use */
#define PNS_IF_SET_SUBM_STATE_SUBM_SUPERORD_LOCKED     (1)
/* the submodule is not yet ready for data exchange but not locked */
#define PNS_IF_SET_SUBM_STATE_SUBM_APPL_READY_PENDING  (2)
/* the submodule is no longer locked */
#define PNS_IF_SET_SUBM_STATE_SUBM_OKAY                (0)

typedef __PACKED_PRE struct PNS_IF_SET_SUBM_STATE_SUBMBLOCK_Ttag
{
  /* the API the submodule belongs to */
  TLR_UINT32 ulApi;
  /* the slot the submodule resides */
  TLR_UINT16 usSlot;
  /* the subslot the submodule resides */
  TLR_UINT16 usSubslot;
  /* the submodule state (see above) */
  TLR_UINT16 usSubmState;
  /* the module state, reserved for future use! */
  TLR_UINT16 usModuleState;
} __PACKED_POST PNS_IF_SET_SUBM_STATE_SUBMBLOCK_T;

typedef __PACKED_PRE struct PNS_IF_SET_SUBM_STATE_DATA_REQ_Ttag
{
  /* amount of submodules contained in this packet */
  TLR_UINT32                         ulSubmCnt;
  /* the first of ulSubmCnt submodule datasets */
  PNS_IF_SET_SUBM_STATE_SUBMBLOCK_T  atSubm[1];
} __PACKED_POST PNS_IF_SET_SUBM_STATE_DATA_REQ_T;

typedef struct PNS_IF_SET_SUBM_STATE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                tHead;
  PNS_IF_SET_SUBM_STATE_DATA_REQ_T   tData;
} PNS_IF_SET_SUBM_STATE_REQ_T;

typedef TLR_EMPTY_PACKET_T   PNS_IF_SET_SUBM_STATE_CNF_T;


typedef union PNS_IF_SET_SUBM_STATE_PCK_Ttag
{
  /** request */
  PNS_IF_SET_SUBM_STATE_REQ_T        tReq;
  /** response */
  PNS_IF_SET_SUBM_STATE_CNF_T        tCnf;
} PNS_IF_SET_SUBM_STATE_PCK_T;


/**
 * @}
 */


/*
 * UNION  OF  ALL  PNS_IF  PACKETS
 */
typedef union PROFINET_PNS_IF_PACKET_Ttag
{
   PNS_IF_SET_CONFIGURATION_REQUEST_PCK_T  tSetConfigPck;          // stack configuration packet
   PNS_IF_SET_WARMSTART_PCK_T              tWarmstartPck;          // Warmstart package
   PNS_IF_PLUG_MODULE_PCK_T                tPlugModulePck;         // Module Plug package
   PNS_IF_PLUG_SUBMODULE_PCK_T             tPlugSubmodulePck;      // Submodule Plug package
   PNS_IF_PULL_MODULE_PCK_T                tPullModulePck;         // Module Pull package
   PNS_IF_PULL_SUBMODULE_PCK_T             tPullSubmodulePck;      // Submodule Pull package
   PNS_IF_AR_CHECK_PCK_T                   tARCheckPck;            // AR check package
   PNS_IF_CHECK_IND_PCK_T                  tCheckIndPck;           // Check indication package
   PNS_IF_CONNECTREQ_DONE_PCK_T            tConDonePck;            // Connection done package
   PNS_IF_PARAM_END_PCK_T                  tParamEndPck;           // Parameter end indication package
   PNS_IF_APPL_READY_PCK_T                 tApplReadyPck;          // Application ready indication package
   PNS_IF_AR_IN_DATA_PCK_T                 tARInDataPck;           // AR 1st InData indication package
   PNS_IF_READ_RECORD_PCK_T                tReadRecordPck;         // Read record package
   PNS_IF_WRITE_RECORD_PCK_T               tWriteRecordPck;        // Write record package
   PNS_IF_AR_ABORT_IND_PCK_T               tARAbortIndPck;         // AR abort indication package
   PNS_IF_SAVE_STATION_NAME_PCK_T          tSaveStationNamePck;    // Save station name package
   PNS_IF_SAVE_STATION_TYPE_PCK_T          tSaveStationTypePck;    // Save station type package
   PNS_IF_SAVE_IP_ADDR_PCK_T               tSaveIPAddrPck;         // Save IP address package
   PNS_IF_START_LED_BLINKING_PCK_T         tStartBlinkPck;         // Start LED blinking package
   PNS_IF_STOP_LED_BLINKING_PCK_T          tStopBlinkPck;          // Start LED blinking package
   PNS_IF_RESET_FACTORY_SETTINGS_PCK_T     tResetFactPck;          // reset to factory settings package
   PNS_IF_APDU_STATUS_CHANGED_PCK_T        tAPDUStatusPck;         // APDU staus changed indication package
   PNS_IF_ALARM_PCK_T                      tAlarmPck;              // Alarm package
   PNS_IF_RELEASE_REQ_PCK_T                tReleaseReqPck;         // Release request package
   PNS_IF_LINK_STATUS_CHANGED_PCK_T        tLinkStatPck;           // Link status changed package
   PNS_IF_SEND_PROCESS_ALARM_PCK_T         tSendProcAlarmPck;      // Send process alarm package
   PNS_IF_SEND_DIAG_ALARM_PCK_T            tSendDiagAlarmPck;      // Send diagnostic alarm package
   PNS_IF_RETURN_OF_SUB_ALARM_PCK_T        tRetOfSubAlarmPck;      // Return of submodule alarm package
   PNS_IF_ABORT_CONNECTION_PCK_T           tAbortConPck;           // Abort connection package
   PNS_IF_GET_DEVICE_HANDLE_PCK_T          tGetDevHandlePck;       // Get device handle package
   PNS_IF_GET_STATION_NAME_PCK_T           tGetStationNamePck;     // Get station name package
   PNS_IF_GET_STATION_TYPE_PCK_T           tGetStationTypePck;     // Get station type package
   PNS_IF_GET_IP_ADDR_PCK_T                tGetIPAdrPck;           // Get IP address package;
   PNS_REG_FATAL_ERROR_CALLBACK_PCK_T      tRegFatalErrCBPck;      // Register the fatal error callback function
   PNS_UNREG_FATAL_ERROR_CALLBACK_PCK_T    tUnregFatalErrCBPck;    // Register the fatal error callback function
   PNS_IF_USER_ERROR_PCK_T                 tUserErrorPck;          // User error package
   PNS_IF_REGISTER_APPLICATION_PCK_T       tRegisterAPPck;         // Register application conf
   PNS_IF_UNREGISTER_APPLICATION_PCK_T     tUnRegisterAPReqPck;    // Unregister application request
   PNS_IF_SET_OEM_PARAMETERS_PCK_T         tSetOemParamPck;        // set OEM parameter request packet
   PNS_IF_STORE_REMANENT_DATA_PCK_T        tStoreRemaDataPck;      // store remanent data packet
   PNS_IF_LOAD_REMANENT_DATA_PCK_T         tLoadRemaDataPck;       // load remanent data packet
   PNS_IF_SET_IOIMAGE_PCK_T                tSetIOImagePck;         // set pointers to local io image
   PNS_IF_SET_IOXS_CONFIG_PCK_T            tSetIOxSConfigPck;      // set IOxS config
   PNS_IF_PLUG_SUBMODULE_EXTENDED_PCK_T    tPlugSubmodExtPck;      // extended plug submodule
   PNS_IF_SET_PORT_MAC_PCK_T               tSetPortMacPck;         // set port MAC addresses
   PNS_IF_GET_XMAC_DIAGNOSIS_PCK_T         tGetXMACDiagPck;        // get XMAC diagnosis
   PNS_IF_GET_DIAGNOSIS_PCK_T              tGetStackDiagPck;       // get diagnosis
   PNS_IF_ADD_CHANNEL_DIAG_PCK_T           tAddChannelDiagPck;     // add Channel Diagnosis
   PNS_IF_ADD_EXTENDED_DIAG_PCK_T          tAddExtChannelDiagPck;  // add Extended Channel Diagnosis
   PNS_IF_ADD_GENERIC_DIAG_PCK_T           tAddGenericDiagPck;     // add Generic Diagnosis
   PNS_IF_REMOVE_DIAG_PCK_T                tRemoveDiagPck;         // remove diagnosis
   PNS_IF_HANDLE_PACKET_T                  tHandlePck;             // handle packet
   PNS_IF_READ_IM_PCK_T                    tReadIMPck;             // read i&m packet
   PNS_IF_WRITE_IM_PCK_T                   tWriteIMPck;            // write i&m packet
   PNS_IF_PARAMET_SPEEDUP_SUPPORTED_PCK_T  tParSpeedSuppPck;       // parameter speedup supported indication
} PROFINET_PNS_IF_PACKET_T;

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__PNSIF_API_PACKET)
#endif


/*************************************************************************************/
#endif /* #ifndef __PNSIF_API_PUBLIC_H */
